/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.crypto.tink.util.KeysDownloader;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class GooglePaymentsPublicKeysManager {
    public static final NetHttpTransport DEFAULT_HTTP_TRANSPORT = new NetHttpTransport.Builder().build();
    public static final String KEYS_URL_PRODUCTION = "https://payments.developers.google.com/paymentmethodtoken/keys.json";
    public static final String KEYS_URL_TEST = "https://payments.developers.google.com/paymentmethodtoken/test/keys.json";
    private static final Executor DEFAULT_BACKGROUND_EXECUTOR = Executors.newCachedThreadPool();
    private final KeysDownloader downloader;
    public static final GooglePaymentsPublicKeysManager INSTANCE_PRODUCTION = new GooglePaymentsPublicKeysManager(DEFAULT_BACKGROUND_EXECUTOR, (HttpTransport)DEFAULT_HTTP_TRANSPORT, "https://payments.developers.google.com/paymentmethodtoken/keys.json");
    public static final GooglePaymentsPublicKeysManager INSTANCE_TEST = new GooglePaymentsPublicKeysManager(DEFAULT_BACKGROUND_EXECUTOR, (HttpTransport)DEFAULT_HTTP_TRANSPORT, "https://payments.developers.google.com/paymentmethodtoken/test/keys.json");

    GooglePaymentsPublicKeysManager(Executor backgroundExecutor, HttpTransport httpTransport, String keysUrl) {
        this.downloader = new KeysDownloader.Builder().setUrl(keysUrl).setExecutor(backgroundExecutor).setHttpTransport(httpTransport).build();
    }

    HttpTransport getHttpTransport() {
        return this.downloader.getHttpTransport();
    }

    String getUrl() {
        return this.downloader.getUrl();
    }

    String getTrustedSigningKeysJson() throws IOException {
        return this.downloader.download();
    }

    public void refreshInBackground() {
        this.downloader.refreshInBackground();
    }

    public static class Builder {
        private HttpTransport httpTransport = DEFAULT_HTTP_TRANSPORT;
        private String keysUrl = "https://payments.developers.google.com/paymentmethodtoken/keys.json";

        public Builder setKeysUrl(String keysUrl) {
            this.keysUrl = keysUrl;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public GooglePaymentsPublicKeysManager build() {
            for (GooglePaymentsPublicKeysManager instance : Arrays.asList(INSTANCE_PRODUCTION, INSTANCE_TEST)) {
                if (instance.getHttpTransport() != this.httpTransport || !instance.getUrl().equals(this.keysUrl)) continue;
                return instance;
            }
            return new GooglePaymentsPublicKeysManager(DEFAULT_BACKGROUND_EXECUTOR, this.httpTransport, this.keysUrl);
        }
    }
}

