/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Enums;
import java.nio.charset.StandardCharsets;

class PaymentMethodTokenConstants {
    public static final String GOOGLE_SENDER_ID = "Google";
    public static final String HMAC_SHA256_ALGO = "HmacSha256";
    public static final byte[] HKDF_EMPTY_SALT = new byte[0];
    public static final byte[] GOOGLE_CONTEXT_INFO_ECV1 = "Google".getBytes(StandardCharsets.UTF_8);
    public static final String AES_CTR_ALGO = "AES/CTR/NoPadding";
    public static final byte[] AES_CTR_ZERO_IV = new byte[16];
    public static final EllipticCurves.CurveType P256_CURVE_TYPE = EllipticCurves.CurveType.NIST_P256;
    public static final EllipticCurves.PointFormatType UNCOMPRESSED_POINT_FORMAT = EllipticCurves.PointFormatType.UNCOMPRESSED;
    public static final String PROTOCOL_VERSION_EC_V1 = "ECv1";
    public static final String PROTOCOL_VERSION_EC_V2 = "ECv2";
    public static final String PROTOCOL_VERSION_EC_V2_SIGNING_ONLY = "ECv2SigningOnly";
    public static final Enums.HashType ECDSA_HASH_SHA256 = Enums.HashType.SHA256;
    public static final String JSON_ENCRYPTED_MESSAGE_KEY = "encryptedMessage";
    public static final String JSON_EPHEMERAL_PUBLIC_KEY = "ephemeralPublicKey";
    public static final String JSON_INTERMEDIATE_SIGNING_KEY = "intermediateSigningKey";
    public static final String JSON_KEY_EXPIRATION_KEY = "keyExpiration";
    public static final String JSON_KEY_VALUE_KEY = "keyValue";
    public static final String JSON_MESSAGE_EXPIRATION_KEY = "messageExpiration";
    public static final String JSON_PROTOCOL_VERSION_KEY = "protocolVersion";
    public static final String JSON_SIGNATURES_KEY = "signatures";
    public static final String JSON_SIGNATURE_KEY = "signature";
    public static final String JSON_SIGNED_KEY_KEY = "signedKey";
    public static final String JSON_SIGNED_MESSAGE_KEY = "signedMessage";
    public static final String JSON_TAG_KEY = "tag";

    PaymentMethodTokenConstants() {
    }

    static enum ProtocolVersionConfig {
        EC_V1("ECv1", 16, 16, true, false),
        EC_V2("ECv2", 32, 32, true, true),
        EC_V2_SIGNING_ONLY("ECv2SigningOnly", 32, 32, false, true);

        public final String protocolVersion;
        public final int aesCtrKeySize;
        public final int hmacSha256KeySize;
        public final boolean isEncryptionRequired;
        public final boolean supportsIntermediateSigningKeys;

        private ProtocolVersionConfig(String protocolVersion, int aesCtrKeySize, int hmacSha256KeySize, boolean isEncryptionRequired, boolean supportsIntermediateSigningKeys) {
            this.protocolVersion = protocolVersion;
            this.aesCtrKeySize = aesCtrKeySize;
            this.hmacSha256KeySize = hmacSha256KeySize;
            this.isEncryptionRequired = isEncryptionRequired;
            this.supportsIntermediateSigningKeys = supportsIntermediateSigningKeys;
        }

        public static ProtocolVersionConfig forProtocolVersion(String protocolVersion) {
            for (ProtocolVersionConfig protocolVersionConfig : ProtocolVersionConfig.values()) {
                if (!protocolVersionConfig.protocolVersion.equals(protocolVersion)) continue;
                return protocolVersionConfig;
            }
            throw new IllegalArgumentException("Unknown protocol version: " + protocolVersion);
        }
    }
}

