/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenConstants;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenRecipientKem;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenUtil;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Hkdf;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

class PaymentMethodTokenHybridDecrypt
implements HybridDecrypt {
    private final PaymentMethodTokenRecipientKem recipientKem;
    private final PaymentMethodTokenConstants.ProtocolVersionConfig protocolVersionConfig;

    PaymentMethodTokenHybridDecrypt(final ECPrivateKey recipientPrivateKey, PaymentMethodTokenConstants.ProtocolVersionConfig protocolVersionConfig) throws GeneralSecurityException {
        this(new PaymentMethodTokenRecipientKem(){

            @Override
            public byte[] computeSharedSecret(byte[] ephemeralPublicKey) throws GeneralSecurityException {
                ECPublicKey publicKey = EllipticCurves.getEcPublicKey((ECParameterSpec)recipientPrivateKey.getParams(), (EllipticCurves.PointFormatType)PaymentMethodTokenConstants.UNCOMPRESSED_POINT_FORMAT, (byte[])ephemeralPublicKey);
                return EllipticCurves.computeSharedSecret((ECPrivateKey)recipientPrivateKey, (ECPublicKey)publicKey);
            }
        }, protocolVersionConfig);
    }

    PaymentMethodTokenHybridDecrypt(PaymentMethodTokenRecipientKem recipientKem, PaymentMethodTokenConstants.ProtocolVersionConfig protocolVersionConfig) {
        this.recipientKem = recipientKem;
        this.protocolVersionConfig = protocolVersionConfig;
    }

    public byte[] decrypt(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
        try {
            JSONObject json = new JSONObject(new String(ciphertext, StandardCharsets.UTF_8));
            this.validate(json);
            byte[] demKey = this.kem(json, contextInfo);
            return this.dem(json, demKey);
        }
        catch (JSONException e) {
            throw new GeneralSecurityException("cannot decrypt; failed to parse JSON");
        }
    }

    private byte[] kem(JSONObject json, byte[] contextInfo) throws GeneralSecurityException, JSONException {
        int demKeySize = this.protocolVersionConfig.aesCtrKeySize + this.protocolVersionConfig.hmacSha256KeySize;
        byte[] ephemeralPublicKey = Base64.decode((String)json.getString("ephemeralPublicKey"));
        byte[] sharedSecret = this.recipientKem.computeSharedSecret(ephemeralPublicKey);
        return Hkdf.computeEciesHkdfSymmetricKey((byte[])ephemeralPublicKey, (byte[])sharedSecret, (String)"HmacSha256", (byte[])PaymentMethodTokenConstants.HKDF_EMPTY_SALT, (byte[])contextInfo, (int)demKeySize);
    }

    private byte[] dem(JSONObject json, byte[] demKey) throws GeneralSecurityException, JSONException {
        byte[] hmacSha256Key = Arrays.copyOfRange(demKey, this.protocolVersionConfig.aesCtrKeySize, demKey.length);
        byte[] encryptedMessage = Base64.decode((String)json.getString("encryptedMessage"));
        byte[] computedTag = PaymentMethodTokenUtil.hmacSha256(hmacSha256Key, encryptedMessage);
        byte[] expectedTag = Base64.decode((String)json.getString("tag"));
        if (!Bytes.equal((byte[])expectedTag, (byte[])computedTag)) {
            throw new GeneralSecurityException("cannot decrypt; invalid MAC");
        }
        byte[] aesCtrKey = Arrays.copyOf(demKey, this.protocolVersionConfig.aesCtrKeySize);
        return PaymentMethodTokenUtil.aesCtr(aesCtrKey, encryptedMessage);
    }

    private void validate(JSONObject payload) throws GeneralSecurityException {
        if (!(payload.has("encryptedMessage") && payload.has("tag") && payload.has("ephemeralPublicKey") && payload.length() == 3)) {
            throw new GeneralSecurityException("The payload must contain exactly encryptedMessage, tag and ephemeralPublicKey");
        }
    }
}

