/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenConstants;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenUtil;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.subtle.EciesHkdfSenderKem;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

class PaymentMethodTokenHybridEncrypt
implements HybridEncrypt {
    private final EciesHkdfSenderKem senderKem;
    private final PaymentMethodTokenConstants.ProtocolVersionConfig protocolVersionConfig;

    public PaymentMethodTokenHybridEncrypt(ECPublicKey recipientPublicKey, PaymentMethodTokenConstants.ProtocolVersionConfig protocolVersionConfig) {
        this.senderKem = new EciesHkdfSenderKem(recipientPublicKey);
        this.protocolVersionConfig = protocolVersionConfig;
    }

    public byte[] encrypt(byte[] plaintext, byte[] contextInfo) throws GeneralSecurityException {
        int symmetricKeySize = this.protocolVersionConfig.aesCtrKeySize + this.protocolVersionConfig.hmacSha256KeySize;
        EciesHkdfSenderKem.KemKey kemKey = this.senderKem.generateKey("HmacSha256", PaymentMethodTokenConstants.HKDF_EMPTY_SALT, contextInfo, symmetricKeySize, PaymentMethodTokenConstants.UNCOMPRESSED_POINT_FORMAT);
        byte[] aesCtrKey = Arrays.copyOfRange(kemKey.getSymmetricKey(), 0, this.protocolVersionConfig.aesCtrKeySize);
        byte[] ciphertext = PaymentMethodTokenUtil.aesCtr(aesCtrKey, plaintext);
        byte[] hmacSha256Key = Arrays.copyOfRange(kemKey.getSymmetricKey(), this.protocolVersionConfig.aesCtrKeySize, symmetricKeySize);
        byte[] tag = PaymentMethodTokenUtil.hmacSha256(hmacSha256Key, ciphertext);
        byte[] ephemeralPublicKey = kemKey.getKemBytes();
        try {
            return new JSONObject().put("encryptedMessage", (Object)Base64.encode((byte[])ciphertext)).put("tag", (Object)Base64.encode((byte[])tag)).put("ephemeralPublicKey", (Object)Base64.encode((byte[])ephemeralPublicKey)).toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (JSONException e) {
            throw new GeneralSecurityException("cannot encrypt; JSON error");
        }
    }
}

