/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.apps.paymentmethodtoken.GooglePaymentsPublicKeysManager;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenConstants;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenHybridDecrypt;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenRecipientKem;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenUtil;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.subtle.EcdsaVerifyJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.Instant;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class PaymentMethodTokenRecipient {
    private final String protocolVersion;
    private final List<SenderVerifyingKeysProvider> senderVerifyingKeysProviders;
    private final List<HybridDecrypt> hybridDecrypters = new ArrayList<HybridDecrypt>();
    private final String senderId;
    private final String recipientId;

    PaymentMethodTokenRecipient(String protocolVersion, List<SenderVerifyingKeysProvider> senderVerifyingKeysProviders, String senderId, List<ECPrivateKey> recipientPrivateKeys, List<PaymentMethodTokenRecipientKem> recipientKems, String recipientId) throws GeneralSecurityException {
        if (!(protocolVersion.equals("ECv1") || protocolVersion.equals("ECv2") || protocolVersion.equals("ECv2SigningOnly"))) {
            throw new IllegalArgumentException("invalid version: " + protocolVersion);
        }
        this.protocolVersion = protocolVersion;
        if (senderVerifyingKeysProviders == null || senderVerifyingKeysProviders.isEmpty()) {
            throw new IllegalArgumentException("must set at least one way to get sender's verifying key using Builder.fetchSenderVerifyingKeysWith or Builder.senderVerifyingKeys");
        }
        this.senderVerifyingKeysProviders = senderVerifyingKeysProviders;
        this.senderId = senderId;
        PaymentMethodTokenConstants.ProtocolVersionConfig protocolVersionConfig = PaymentMethodTokenConstants.ProtocolVersionConfig.forProtocolVersion(protocolVersion);
        if (protocolVersionConfig.isEncryptionRequired) {
            if (recipientPrivateKeys.isEmpty() && recipientKems.isEmpty()) {
                throw new IllegalArgumentException("must add at least one recipient's decrypting key using Builder.addRecipientPrivateKey or Builder.addRecipientKem");
            }
            for (ECPrivateKey privateKey : recipientPrivateKeys) {
                this.hybridDecrypters.add(new PaymentMethodTokenHybridDecrypt(privateKey, protocolVersionConfig));
            }
            for (PaymentMethodTokenRecipientKem kem : recipientKems) {
                this.hybridDecrypters.add(new PaymentMethodTokenHybridDecrypt(kem, protocolVersionConfig));
            }
        } else if (!recipientPrivateKeys.isEmpty() || !recipientKems.isEmpty()) {
            throw new IllegalArgumentException("must not set private decrypting key using Builder.addRecipientPrivateKey or Builder.addRecipientDecrypter");
        }
        if (recipientId == null) {
            throw new IllegalArgumentException("must set recipient Id using Builder.recipientId");
        }
        this.recipientId = recipientId;
    }

    private PaymentMethodTokenRecipient(Builder builder) throws GeneralSecurityException {
        this(builder.protocolVersion, builder.senderVerifyingKeysProviders, builder.senderId, builder.recipientPrivateKeys, builder.recipientKems, builder.recipientId);
    }

    public String unseal(String sealedMessage) throws GeneralSecurityException {
        try {
            if (this.protocolVersion.equals("ECv1")) {
                return this.unsealECV1(sealedMessage);
            }
            if (this.protocolVersion.equals("ECv2")) {
                return this.unsealECV2(sealedMessage);
            }
            if (this.protocolVersion.equals("ECv2SigningOnly")) {
                return this.unsealECV2SigningOnly(sealedMessage);
            }
            throw new IllegalArgumentException("unsupported version: " + this.protocolVersion);
        }
        catch (JSONException e) {
            throw new GeneralSecurityException("cannot unseal; invalid JSON message");
        }
    }

    private String unsealECV1(String sealedMessage) throws JSONException, GeneralSecurityException {
        JSONObject jsonMsg = new JSONObject(sealedMessage);
        this.validateECV1(jsonMsg);
        String signedMessage = this.verifyECV1(jsonMsg);
        String decryptedMessage = this.decrypt(signedMessage);
        this.validateMessage(decryptedMessage);
        return decryptedMessage;
    }

    private String unsealECV2(String sealedMessage) throws JSONException, GeneralSecurityException {
        JSONObject jsonMsg = new JSONObject(sealedMessage);
        this.validateECV2(jsonMsg);
        String signedMessage = this.verifyECV2(jsonMsg);
        String decryptedMessage = this.decrypt(signedMessage);
        this.validateMessage(decryptedMessage);
        return decryptedMessage;
    }

    private String unsealECV2SigningOnly(String sealedMessage) throws JSONException, GeneralSecurityException {
        JSONObject jsonMsg = new JSONObject(sealedMessage);
        this.validateECV2(jsonMsg);
        String message = this.verifyECV2(jsonMsg);
        this.validateMessage(message);
        return message;
    }

    private String verifyECV1(JSONObject jsonMsg) throws GeneralSecurityException, JSONException {
        byte[] signature = Base64.decode((String)jsonMsg.getString("signature"));
        String signedMessage = jsonMsg.getString("signedMessage");
        byte[] signedBytes = this.getSignedBytes(this.protocolVersion, signedMessage);
        PaymentMethodTokenRecipient.verify(this.protocolVersion, this.senderVerifyingKeysProviders, Collections.singletonList(signature), signedBytes);
        return signedMessage;
    }

    private String verifyECV2(JSONObject jsonMsg) throws GeneralSecurityException, JSONException {
        byte[] signature = Base64.decode((String)jsonMsg.getString("signature"));
        String signedMessage = jsonMsg.getString("signedMessage");
        byte[] signedBytes = this.getSignedBytes(this.protocolVersion, signedMessage);
        PaymentMethodTokenRecipient.verify(this.protocolVersion, this.verifyIntermediateSigningKey(jsonMsg), Collections.singletonList(signature), signedBytes);
        return signedMessage;
    }

    private byte[] getSignedBytes(String protocolVersion, String signedMessage) throws GeneralSecurityException {
        return PaymentMethodTokenUtil.toLengthValue(this.senderId, this.recipientId, protocolVersion, signedMessage);
    }

    private void validateMessage(String decryptedMessage) throws GeneralSecurityException, JSONException {
        Long expirationInMillis;
        JSONObject decodedMessage;
        try {
            decodedMessage = new JSONObject(decryptedMessage);
        }
        catch (JSONException e) {
            return;
        }
        if (decodedMessage.has("messageExpiration") && (expirationInMillis = Long.valueOf(Long.parseLong(decodedMessage.getString("messageExpiration")))) <= Instant.now().getMillis()) {
            throw new GeneralSecurityException("expired payload");
        }
    }

    private static void verify(String protocolVersion, List<SenderVerifyingKeysProvider> senderVerifyingKeysProviders, List<byte[]> signatures, byte[] signedBytes) throws GeneralSecurityException {
        boolean verified = false;
        for (SenderVerifyingKeysProvider verifyingKeysProvider : senderVerifyingKeysProviders) {
            for (ECPublicKey publicKey : verifyingKeysProvider.get(protocolVersion)) {
                EcdsaVerifyJce verifier = new EcdsaVerifyJce(publicKey, PaymentMethodTokenConstants.ECDSA_HASH_SHA256, EllipticCurves.EcdsaEncoding.DER);
                for (byte[] signature : signatures) {
                    try {
                        verifier.verify(signature, signedBytes);
                        verified = true;
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                }
            }
        }
        if (!verified) {
            throw new GeneralSecurityException("cannot verify signature");
        }
    }

    private String decrypt(String ciphertext) throws GeneralSecurityException {
        for (HybridDecrypt hybridDecrypter : this.hybridDecrypters) {
            try {
                byte[] cleartext = hybridDecrypter.decrypt(ciphertext.getBytes(StandardCharsets.UTF_8), PaymentMethodTokenConstants.GOOGLE_CONTEXT_INFO_ECV1);
                return new String(cleartext, StandardCharsets.UTF_8);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        throw new GeneralSecurityException("cannot decrypt");
    }

    private void validateECV1(JSONObject jsonMsg) throws GeneralSecurityException, JSONException {
        if (!(jsonMsg.has("protocolVersion") && jsonMsg.has("signature") && jsonMsg.has("signedMessage") && jsonMsg.length() == 3)) {
            throw new GeneralSecurityException("ECv1 message must contain exactly protocolVersion, signature and signedMessage");
        }
        String version = jsonMsg.getString("protocolVersion");
        if (!version.equals(this.protocolVersion)) {
            throw new GeneralSecurityException("invalid version: " + version);
        }
    }

    private void validateECV2(JSONObject jsonMsg) throws GeneralSecurityException, JSONException {
        if (!(jsonMsg.has("protocolVersion") && jsonMsg.has("signature") && jsonMsg.has("signedMessage") && jsonMsg.has("intermediateSigningKey") && jsonMsg.length() == 4)) {
            throw new GeneralSecurityException(this.protocolVersion + " message must contain exactly protocolVersion, intermediateSigningKey, signature and signedMessage");
        }
        String version = jsonMsg.getString("protocolVersion");
        if (!version.equals(this.protocolVersion)) {
            throw new GeneralSecurityException("invalid version: " + version);
        }
    }

    private List<SenderVerifyingKeysProvider> verifyIntermediateSigningKey(JSONObject jsonMsg) throws GeneralSecurityException, JSONException {
        JSONObject intermediateSigningKey = jsonMsg.getJSONObject("intermediateSigningKey");
        this.validateIntermediateSigningKey(intermediateSigningKey);
        ArrayList<byte[]> signatures = new ArrayList<byte[]>();
        JSONArray signaturesJson = intermediateSigningKey.getJSONArray("signatures");
        for (int i = 0; i < signaturesJson.length(); ++i) {
            signatures.add(Base64.decode((String)signaturesJson.getString(i)));
        }
        String signedKeyAsString = intermediateSigningKey.getString("signedKey");
        byte[] signedBytes = PaymentMethodTokenUtil.toLengthValue(this.senderId, this.protocolVersion, signedKeyAsString);
        PaymentMethodTokenRecipient.verify(this.protocolVersion, this.senderVerifyingKeysProviders, signatures, signedBytes);
        JSONObject signedKey = new JSONObject(signedKeyAsString);
        this.validateSignedKey(signedKey);
        final String key = signedKey.getString("keyValue");
        SenderVerifyingKeysProvider provider = new SenderVerifyingKeysProvider(){

            @Override
            public List<ECPublicKey> get(String protocolVersion) throws GeneralSecurityException {
                if (PaymentMethodTokenRecipient.this.protocolVersion.equals(protocolVersion)) {
                    return Collections.singletonList(PaymentMethodTokenUtil.x509EcPublicKey(key));
                }
                return Collections.emptyList();
            }
        };
        return Collections.singletonList(provider);
    }

    private JSONObject validateIntermediateSigningKey(JSONObject intermediateSigningKey) throws GeneralSecurityException {
        if (!intermediateSigningKey.has("signatures") || !intermediateSigningKey.has("signedKey") || intermediateSigningKey.length() != 2) {
            throw new GeneralSecurityException("intermediateSigningKey must contain exactly signedKey and signatures");
        }
        return intermediateSigningKey;
    }

    private void validateSignedKey(JSONObject signedKey) throws GeneralSecurityException, JSONException {
        if (!signedKey.has("keyValue") || !signedKey.has("keyExpiration")) {
            throw new GeneralSecurityException("intermediateSigningKey.signedKey must contain keyValue and keyExpiration");
        }
        Long expirationInMillis = Long.parseLong(signedKey.getString("keyExpiration"));
        if (expirationInMillis <= Instant.now().getMillis()) {
            throw new GeneralSecurityException("expired intermediateSigningKey");
        }
    }

    private static List<ECPublicKey> parseTrustedSigningKeysJson(String protocolVersion, String trustedSigningKeysJson) throws GeneralSecurityException {
        ArrayList<ECPublicKey> senderVerifyingKeys = new ArrayList<ECPublicKey>();
        try {
            JSONArray keys = new JSONObject(trustedSigningKeysJson).getJSONArray("keys");
            for (int i = 0; i < keys.length(); ++i) {
                Long expirationInMillis;
                JSONObject key = keys.getJSONObject(i);
                if (!protocolVersion.equals(key.getString("protocolVersion")) || (key.has("keyExpiration") ? (expirationInMillis = Long.valueOf(Long.parseLong(key.getString("keyExpiration")))) <= Instant.now().getMillis() : !protocolVersion.equals("ECv1"))) continue;
                senderVerifyingKeys.add(PaymentMethodTokenUtil.x509EcPublicKey(key.getString("keyValue")));
            }
        }
        catch (JSONException e) {
            throw new GeneralSecurityException("failed to extract trusted signing public keys", e);
        }
        if (senderVerifyingKeys.isEmpty()) {
            throw new GeneralSecurityException("no trusted keys are available for this protocol version");
        }
        return senderVerifyingKeys;
    }

    private static interface SenderVerifyingKeysProvider {
        public List<ECPublicKey> get(String var1) throws GeneralSecurityException;
    }

    public static class Builder {
        private String protocolVersion = "ECv1";
        private String senderId = "Google";
        private String recipientId = null;
        private final List<SenderVerifyingKeysProvider> senderVerifyingKeysProviders = new ArrayList<SenderVerifyingKeysProvider>();
        private final List<ECPrivateKey> recipientPrivateKeys = new ArrayList<ECPrivateKey>();
        private final List<PaymentMethodTokenRecipientKem> recipientKems = new ArrayList<PaymentMethodTokenRecipientKem>();

        public Builder protocolVersion(String val) {
            this.protocolVersion = val;
            return this;
        }

        public Builder senderId(String val) {
            this.senderId = val;
            return this;
        }

        public Builder recipientId(String val) {
            this.recipientId = val;
            return this;
        }

        public Builder fetchSenderVerifyingKeysWith(final GooglePaymentsPublicKeysManager googlePaymentsPublicKeysManager) throws GeneralSecurityException {
            this.senderVerifyingKeysProviders.add(new SenderVerifyingKeysProvider(){

                @Override
                public List<ECPublicKey> get(String protocolVersion) throws GeneralSecurityException {
                    try {
                        return PaymentMethodTokenRecipient.parseTrustedSigningKeysJson(protocolVersion, googlePaymentsPublicKeysManager.getTrustedSigningKeysJson());
                    }
                    catch (IOException e) {
                        throw new GeneralSecurityException("Failed to fetch keys!", e);
                    }
                }
            });
            return this;
        }

        public Builder senderVerifyingKeys(final String trustedSigningKeysJson) throws GeneralSecurityException {
            this.senderVerifyingKeysProviders.add(new SenderVerifyingKeysProvider(){

                @Override
                public List<ECPublicKey> get(String protocolVersion) throws GeneralSecurityException {
                    return PaymentMethodTokenRecipient.parseTrustedSigningKeysJson(protocolVersion, trustedSigningKeysJson);
                }
            });
            return this;
        }

        public Builder addSenderVerifyingKey(final String val) throws GeneralSecurityException {
            this.senderVerifyingKeysProviders.add(new SenderVerifyingKeysProvider(){

                @Override
                public List<ECPublicKey> get(String protocolVersion) throws GeneralSecurityException {
                    return Collections.singletonList(PaymentMethodTokenUtil.x509EcPublicKey(val));
                }
            });
            return this;
        }

        public Builder addSenderVerifyingKey(final ECPublicKey val) throws GeneralSecurityException {
            this.senderVerifyingKeysProviders.add(new SenderVerifyingKeysProvider(){

                @Override
                public List<ECPublicKey> get(String protocolVersion) throws GeneralSecurityException {
                    return Collections.singletonList(val);
                }
            });
            return this;
        }

        public Builder addRecipientPrivateKey(String val) throws GeneralSecurityException {
            return this.addRecipientPrivateKey(PaymentMethodTokenUtil.pkcs8EcPrivateKey(val));
        }

        public Builder addRecipientPrivateKey(ECPrivateKey val) throws GeneralSecurityException {
            this.recipientPrivateKeys.add(val);
            return this;
        }

        public Builder addRecipientKem(PaymentMethodTokenRecipientKem kem) {
            this.recipientKems.add(kem);
            return this;
        }

        public PaymentMethodTokenRecipient build() throws GeneralSecurityException {
            return new PaymentMethodTokenRecipient(this);
        }
    }
}

