/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenConstants;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;

public final class PaymentMethodTokenRecipientKeyGen {
    private static final String PRIVATE_KEY_FILE = "private_key.bin";
    private static final String PUBLIC_KEY_FILE = "public_key.bin";

    private static void generateKey() throws GeneralSecurityException, IOException {
        KeyPair keyPair = EllipticCurves.generateKeyPair((EllipticCurves.CurveType)PaymentMethodTokenConstants.P256_CURVE_TYPE);
        PaymentMethodTokenRecipientKeyGen.writeBase64(PRIVATE_KEY_FILE, keyPair.getPrivate().getEncoded());
        ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
        PaymentMethodTokenRecipientKeyGen.writeBase64(PUBLIC_KEY_FILE, EllipticCurves.pointEncode((EllipticCurves.CurveType)PaymentMethodTokenConstants.P256_CURVE_TYPE, (EllipticCurves.PointFormatType)PaymentMethodTokenConstants.UNCOMPRESSED_POINT_FORMAT, (ECPoint)publicKey.getW()));
    }

    private static void writeBase64(String pathname, byte[] content) throws IOException {
        File out = new File(pathname);
        if (out.exists()) {
            System.out.println("Please make sure that " + pathname + " does not exist.");
            System.exit(-1);
        }
        FileOutputStream stream = new FileOutputStream(out);
        stream.write(Base64.encode((byte[])content, (int)2));
        stream.close();
    }

    public static void main(String[] args) throws GeneralSecurityException, IOException {
        System.out.println("Generating key....");
        PaymentMethodTokenRecipientKeyGen.generateKey();
        System.out.println("done.");
    }
}

