/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenConstants;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenHybridEncrypt;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenUtil;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.subtle.EcdsaSignJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.json.JSONException;
import org.json.JSONObject;

public final class PaymentMethodTokenSender {
    private final String protocolVersion;
    private final PaymentMethodTokenConstants.ProtocolVersionConfig protocolVersionConfig;
    private final PublicKeySign signer;
    private final String senderIntermediateCert;
    private final String senderId;
    private final String recipientId;
    private HybridEncrypt hybridEncrypter;

    PaymentMethodTokenSender(Builder builder) throws GeneralSecurityException {
        switch (builder.protocolVersion) {
            case "ECv1": {
                PaymentMethodTokenSender.validateV1(builder);
                break;
            }
            case "ECv2": {
                PaymentMethodTokenSender.validateV2(builder);
                break;
            }
            case "ECv2SigningOnly": {
                PaymentMethodTokenSender.validateV2SigningOnly(builder);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid version: " + builder.protocolVersion);
            }
        }
        this.protocolVersion = builder.protocolVersion;
        this.protocolVersionConfig = PaymentMethodTokenConstants.ProtocolVersionConfig.forProtocolVersion(this.protocolVersion);
        this.signer = new EcdsaSignJce(builder.senderIntermediateSigningKey != null ? builder.senderIntermediateSigningKey : builder.senderSigningKey, PaymentMethodTokenConstants.ECDSA_HASH_SHA256, EllipticCurves.EcdsaEncoding.DER);
        this.senderId = builder.senderId;
        if (this.protocolVersionConfig.isEncryptionRequired) {
            this.hybridEncrypter = new PaymentMethodTokenHybridEncrypt(builder.recipientPublicKey, this.protocolVersionConfig);
        }
        if (builder.recipientId == null) {
            throw new IllegalArgumentException("must set recipient Id using Builder.recipientId");
        }
        this.recipientId = builder.recipientId;
        this.senderIntermediateCert = builder.senderIntermediateCert;
    }

    public String seal(String message) throws GeneralSecurityException {
        if (this.protocolVersion.equals("ECv1") || this.protocolVersion.equals("ECv2") || this.protocolVersion.equals("ECv2SigningOnly")) {
            return this.sealV1OrV2(message);
        }
        throw new GeneralSecurityException("Unsupported version: " + this.protocolVersion);
    }

    private String sealV1OrV2(String message) throws GeneralSecurityException {
        String signedMessage = this.protocolVersionConfig.isEncryptionRequired ? new String(this.hybridEncrypter.encrypt(message.getBytes(StandardCharsets.UTF_8), PaymentMethodTokenConstants.GOOGLE_CONTEXT_INFO_ECV1), StandardCharsets.UTF_8) : message;
        return this.signV1OrV2(signedMessage);
    }

    private String signV1OrV2(String message) throws GeneralSecurityException {
        byte[] toSignBytes = PaymentMethodTokenUtil.toLengthValue(this.senderId, this.recipientId, this.protocolVersion, message);
        byte[] signature = this.signer.sign(toSignBytes);
        try {
            JSONObject result = new JSONObject().put("signedMessage", (Object)message).put("protocolVersion", (Object)this.protocolVersion).put("signature", (Object)Base64.encode((byte[])signature));
            if (this.senderIntermediateCert != null) {
                result.put("intermediateSigningKey", (Object)new JSONObject(this.senderIntermediateCert));
            }
            return result.toString();
        }
        catch (JSONException e) {
            throw new GeneralSecurityException("cannot seal; JSON error");
        }
    }

    private static void validateV1(Builder builder) {
        if (builder.senderSigningKey == null) {
            throw new IllegalArgumentException("must set sender's signing key using Builder.senderSigningKey");
        }
        if (builder.senderIntermediateSigningKey != null) {
            throw new IllegalArgumentException("must not set sender's intermediate signing key using Builder.senderIntermediateSigningKey");
        }
        if (builder.senderIntermediateCert != null) {
            throw new IllegalArgumentException("must not set signed sender's intermediate signing key using Builder.senderIntermediateCert");
        }
        if (builder.recipientPublicKey == null) {
            throw new IllegalArgumentException("must set recipient's public key using Builder.recipientPublicKey");
        }
    }

    private static void validateV2(Builder builder) {
        PaymentMethodTokenSender.validateIntermediateSigningKeys(builder);
        if (builder.recipientPublicKey == null) {
            throw new IllegalArgumentException("must set recipient's public key using Builder.recipientPublicKey");
        }
    }

    private static void validateV2SigningOnly(Builder builder) {
        PaymentMethodTokenSender.validateIntermediateSigningKeys(builder);
        if (builder.recipientPublicKey != null) {
            throw new IllegalArgumentException("must not set recipient's public key using Builder.recipientPublicKey");
        }
    }

    private static void validateIntermediateSigningKeys(Builder builder) {
        if (builder.senderSigningKey != null) {
            throw new IllegalArgumentException("must not set sender's signing key using Builder.senderSigningKey");
        }
        if (builder.senderIntermediateSigningKey == null) {
            throw new IllegalArgumentException("must set sender's intermediate signing key using Builder.senderIntermediateSigningKey");
        }
        if (builder.senderIntermediateCert == null) {
            throw new IllegalArgumentException("must set signed sender's intermediate signing key using Builder.senderIntermediateCert");
        }
    }

    public static class Builder {
        private String protocolVersion = "ECv1";
        private String senderId = "Google";
        private String recipientId = null;
        private ECPrivateKey senderSigningKey = null;
        private ECPrivateKey senderIntermediateSigningKey = null;
        private String senderIntermediateCert = null;
        private ECPublicKey recipientPublicKey = null;

        public Builder protocolVersion(String val) {
            this.protocolVersion = val;
            return this;
        }

        public Builder senderId(String val) {
            this.senderId = val;
            return this;
        }

        public Builder recipientId(String val) {
            this.recipientId = val;
            return this;
        }

        public Builder senderSigningKey(String val) throws GeneralSecurityException {
            this.senderSigningKey = PaymentMethodTokenUtil.pkcs8EcPrivateKey(val);
            return this;
        }

        public Builder senderSigningKey(ECPrivateKey val) throws GeneralSecurityException {
            this.senderSigningKey = val;
            return this;
        }

        public Builder senderIntermediateSigningKey(String val) throws GeneralSecurityException {
            return this.senderIntermediateSigningKey(PaymentMethodTokenUtil.pkcs8EcPrivateKey(val));
        }

        public Builder senderIntermediateSigningKey(ECPrivateKey val) throws GeneralSecurityException {
            this.senderIntermediateSigningKey = val;
            return this;
        }

        public Builder senderIntermediateCert(String val) throws GeneralSecurityException {
            this.senderIntermediateCert = val;
            return this;
        }

        public Builder recipientPublicKey(String val) throws GeneralSecurityException {
            this.recipientPublicKey = PaymentMethodTokenUtil.x509EcPublicKey(val);
            return this;
        }

        public Builder rawUncompressedRecipientPublicKey(String val) throws GeneralSecurityException {
            this.recipientPublicKey = PaymentMethodTokenUtil.rawUncompressedEcPublicKey(val);
            return this;
        }

        public Builder recipientPublicKey(ECPublicKey val) throws GeneralSecurityException {
            this.recipientPublicKey = val;
            return this;
        }

        public PaymentMethodTokenSender build() throws GeneralSecurityException {
            return new PaymentMethodTokenSender(this);
        }
    }
}

