/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenConstants;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class PaymentMethodTokenUtil {
    PaymentMethodTokenUtil() {
    }

    static ECPublicKey rawUncompressedEcPublicKey(String rawUncompressedPublicKey) throws GeneralSecurityException {
        return EllipticCurves.getEcPublicKey((EllipticCurves.CurveType)PaymentMethodTokenConstants.P256_CURVE_TYPE, (EllipticCurves.PointFormatType)PaymentMethodTokenConstants.UNCOMPRESSED_POINT_FORMAT, (byte[])Base64.decode((String)rawUncompressedPublicKey));
    }

    static ECPublicKey x509EcPublicKey(String x509PublicKey) throws GeneralSecurityException {
        return EllipticCurves.getEcPublicKey((byte[])Base64.decode((String)x509PublicKey));
    }

    static ECPrivateKey pkcs8EcPrivateKey(String pkcs8PrivateKey) throws GeneralSecurityException {
        return EllipticCurves.getEcPrivateKey((byte[])Base64.decode((String)pkcs8PrivateKey));
    }

    static byte[] toLengthValue(String ... chunks) throws GeneralSecurityException {
        byte[] out = new byte[]{};
        for (String chunk : chunks) {
            byte[] bytes = chunk.getBytes(StandardCharsets.UTF_8);
            out = Bytes.concat((byte[][])new byte[][]{out, Bytes.intToByteArray((int)4, (int)bytes.length)});
            out = Bytes.concat((byte[][])new byte[][]{out, bytes});
        }
        return out;
    }

    static byte[] aesCtr(byte[] encryptionKey, byte[] message) throws GeneralSecurityException {
        Cipher cipher = (Cipher)EngineFactory.CIPHER.getInstance("AES/CTR/NoPadding");
        cipher.init(1, (Key)new SecretKeySpec(encryptionKey, "AES"), new IvParameterSpec(PaymentMethodTokenConstants.AES_CTR_ZERO_IV));
        return cipher.doFinal(message);
    }

    static byte[] hmacSha256(byte[] macKey, byte[] encryptedMessage) throws GeneralSecurityException {
        SecretKeySpec key = new SecretKeySpec(macKey, "HmacSha256");
        Mac mac = (Mac)EngineFactory.MAC.getInstance("HmacSha256");
        mac.init(key);
        return mac.doFinal(encryptedMessage);
    }
}

