/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.paymentmethodtoken;

import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenConstants;
import com.google.crypto.tink.apps.paymentmethodtoken.PaymentMethodTokenUtil;
import com.google.crypto.tink.subtle.Base64;
import com.google.crypto.tink.subtle.EcdsaSignJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SenderIntermediateCertFactory {
    private final List<PublicKeySign> signers;
    private final String intermediateSigningKey;
    private final String protocolVersion;
    private final String senderId;
    private final long expiration;

    private SenderIntermediateCertFactory(String protocolVersion, String senderId, List<ECPrivateKey> senderSigningKeys, String intermediateSigningKey, long expiration) throws GeneralSecurityException {
        if (!PaymentMethodTokenConstants.ProtocolVersionConfig.forProtocolVersion((String)protocolVersion).supportsIntermediateSigningKeys) {
            throw new IllegalArgumentException("invalid version: " + protocolVersion);
        }
        if (senderSigningKeys.isEmpty()) {
            throw new IllegalArgumentException("must add at least one sender's signing key using Builder.addSenderSigningKey");
        }
        if (expiration == 0L) {
            throw new IllegalArgumentException("must set expiration using Builder.expiration");
        }
        if (expiration < 0L) {
            throw new IllegalArgumentException("invalid negative expiration");
        }
        this.protocolVersion = protocolVersion;
        this.senderId = senderId;
        this.signers = new ArrayList<PublicKeySign>();
        for (ECPrivateKey senderSigningKey : senderSigningKeys) {
            this.signers.add((PublicKeySign)new EcdsaSignJce(senderSigningKey, PaymentMethodTokenConstants.ECDSA_HASH_SHA256, EllipticCurves.EcdsaEncoding.DER));
        }
        this.intermediateSigningKey = intermediateSigningKey;
        this.expiration = expiration;
    }

    public String create() throws GeneralSecurityException {
        try {
            String signedKey = new JSONObject().put("keyValue", (Object)this.intermediateSigningKey).put("keyExpiration", (Object)Long.toString(this.expiration)).toString();
            byte[] toSignBytes = PaymentMethodTokenUtil.toLengthValue(this.senderId, this.protocolVersion, signedKey);
            JSONArray signatures = new JSONArray();
            for (PublicKeySign signer : this.signers) {
                byte[] signature = signer.sign(toSignBytes);
                signatures.put((Object)Base64.encode((byte[])signature));
            }
            return new JSONObject().put("signedKey", (Object)signedKey).put("signatures", (Object)signatures).toString();
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to perform JSON encoding", e);
        }
    }

    public static class Builder {
        private List<ECPrivateKey> senderSigningKeys = new ArrayList<ECPrivateKey>();
        private String intermediateSigningKey;
        private String protocolVersion = "ECv2";
        private String senderId = "Google";
        private long expiration;

        public Builder protocolVersion(String val) {
            this.protocolVersion = val;
            return this;
        }

        public Builder senderId(String val) {
            this.senderId = val;
            return this;
        }

        public Builder expiration(long millisSinceEpoch) {
            this.expiration = millisSinceEpoch;
            return this;
        }

        public Builder addSenderSigningKey(String val) throws GeneralSecurityException {
            return this.addSenderSigningKey(PaymentMethodTokenUtil.pkcs8EcPrivateKey(val));
        }

        public Builder addSenderSigningKey(ECPrivateKey val) throws GeneralSecurityException {
            this.senderSigningKeys.add(val);
            return this;
        }

        public Builder senderIntermediateSigningKey(String val) throws GeneralSecurityException {
            PaymentMethodTokenUtil.x509EcPublicKey(val);
            this.intermediateSigningKey = val;
            return this;
        }

        public SenderIntermediateCertFactory build() throws GeneralSecurityException {
            return new SenderIntermediateCertFactory(this.protocolVersion, this.senderId, this.senderSigningKeys, this.intermediateSigningKey, this.expiration);
        }
    }
}

