/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.Iterable;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsArrayLike;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class CSSStyleDeclaration extends CSSProperties
    implements Iterable<String>, JsArrayLike<String>, JsPropertyMap<String> {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetAttributeUnionType {
    @JsOverlay
    static GetAttributeUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.castToBoolean(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.castToDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetExpressionUnionType {
    @JsOverlay
    static GetExpressionUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.castToBoolean(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.castToDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public String cssText;
  public double length;
  public CSSRule parentRule;

  public native GetAttributeUnionType getAttribute(String name, double flags);

  public native GetAttributeUnionType getAttribute(String name);

  public native GetExpressionUnionType getExpression(String name);

  public native CSSValue getPropertyCSSValue(String propertyName);

  public native String getPropertyPriority(String propertyName);

  public native String getPropertyValue(String propertyName);

  public native String item(double index);

  public native boolean removeAttribute(String name, double flags);

  public native boolean removeAttribute(String name);

  public native boolean removeExpression(String name);

  public native String removeProperty(String propertyName);

  public native void setAttribute(String name, Object value, double flags);

  public native void setAttribute(String name, Object value);

  public native void setExpression(String name, String expr, String language);

  public native void setExpression(String name, String expr);

  public native void setProperty(String propertyName, String value, String priority);

  public native void setProperty(String propertyName, String value);
}
