/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class Event {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ComposedPathArrayUnionType {
    @JsOverlay
    static ComposedPathArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Document asDocument() {
      return Js.cast(this);
    }

    @JsOverlay
    default Element asElement() {
      return Js.cast(this);
    }

    @JsOverlay
    default ShadowRoot asShadowRoot() {
      return Js.cast(this);
    }

    @JsOverlay
    default Window asWindow() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isDocument() {
      return (Object) this instanceof Document;
    }

    @JsOverlay
    default boolean isElement() {
      return (Object) this instanceof Element;
    }

    @JsOverlay
    default boolean isShadowRoot() {
      return (Object) this instanceof ShadowRoot;
    }

    @JsOverlay
    default boolean isWindow() {
      return (Object) this instanceof Window;
    }
  }

  @JsFunction
  public interface DeepPathCallbackFn {
    EventTarget[] onInvoke();
  }

  public static double AT_TARGET;
  public static double BUBBLING_PHASE;
  public static double CAPTURING_PHASE;
  public boolean bubbles;
  public boolean cancelable;
  public boolean composed;
  public EventTarget currentTarget;
  public DeepPathCallbackFn deepPath;
  public boolean defaultPrevented;
  public double eventPhase;
  public String namespaceURI;
  public Element[] path;
  public EventTarget target;
  public double timeStamp;
  public String type;

  public Event(String type, EventInit eventInitDict) {}

  public Event(String type) {}

  public native ComposedPathArrayUnionType[] composedPath();

  public native void initEvent(String eventTypeArg, boolean canBubbleArg, boolean cancelableArg);

  public native void preventDefault();

  public native void stopImmediatePropagation();

  public native void stopPropagation();
}
