/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.Date;
import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import java.lang.Void;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class HTMLMediaElement extends HTMLElement {
  @JsFunction
  public interface OnabortCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OncanplayCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OncanplaythroughCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OndurationchangeCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnemptiedCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnendedCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnerrorCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnloadeddataCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnloadedmetadataCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnloadstartCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnpauseCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnplayCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnplayingCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnprogressCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnratechangeCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnseekedCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnseekingCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnstalledCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnsuspendCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OntimeupdateCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnvolumechangeCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnwaitingCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsOverlay
  public static final double HAVE_CURRENT_DATA = HTMLMediaElement__Constants.HAVE_CURRENT_DATA;

  @JsOverlay
  public static final double HAVE_ENOUGH_DATA = HTMLMediaElement__Constants.HAVE_ENOUGH_DATA;

  @JsOverlay
  public static final double HAVE_FUTURE_DATA = HTMLMediaElement__Constants.HAVE_FUTURE_DATA;

  @JsOverlay public static final double HAVE_METADATA = HTMLMediaElement__Constants.HAVE_METADATA;
  @JsOverlay public static final double HAVE_NOTHING = HTMLMediaElement__Constants.HAVE_NOTHING;
  public boolean autobuffer;
  public boolean autoplay;
  public TimeRanges buffered;
  public boolean controls;
  public String currentSrc;
  public double currentTime;
  public double defaultPlaybackRate;
  public double duration;
  public boolean ended;
  public MediaError error;
  public boolean loop;
  public boolean muted;
  public double networkState;
  public OnabortCallbackFn onabort;
  public OncanplayCallbackFn oncanplay;
  public OncanplaythroughCallbackFn oncanplaythrough;
  public OndurationchangeCallbackFn ondurationchange;
  public OnemptiedCallbackFn onemptied;
  public OnendedCallbackFn onended;
  public OnerrorCallbackFn onerror;
  public OnloadeddataCallbackFn onloadeddata;
  public OnloadedmetadataCallbackFn onloadedmetadata;
  public OnloadstartCallbackFn onloadstart;
  public OnpauseCallbackFn onpause;
  public OnplayCallbackFn onplay;
  public OnplayingCallbackFn onplaying;
  public OnprogressCallbackFn onprogress;
  public OnratechangeCallbackFn onratechange;
  public OnseekedCallbackFn onseeked;
  public OnseekingCallbackFn onseeking;
  public OnstalledCallbackFn onstalled;
  public OnsuspendCallbackFn onsuspend;
  public OntimeupdateCallbackFn ontimeupdate;
  public OnvolumechangeCallbackFn onvolumechange;
  public OnwaitingCallbackFn onwaiting;
  public boolean paused;
  public double playbackRate;
  public TimeRanges played;
  public double readyState;
  public TimeRanges seekable;
  public boolean seeking;
  public String sinkId;
  public String src;
  public TextTrackList textTracks;
  public double volume;

  public native TextTrack addTextTrack(String kind, String label, String language);

  public native TextTrack addTextTrack(String kind, String label);

  public native TextTrack addTextTrack(String kind);

  public native String canPlayType(String type);

  public native Date getStartDate();

  public native void load();

  public native void pause();

  public native Promise<Void> play();

  public native Promise<Void> setSinkId(String sinkId);
}
