/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.JsObject;
import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class RTCPeerConnection implements EventTarget {
  @JsFunction
  public interface AddIceCandidateFailureCallbackFn {
    Object onInvoke(DOMException p0);
  }

  @JsFunction
  public interface OnaddstreamCallbackFn {
    Object onInvoke(MediaStreamEvent p0);
  }

  @JsFunction
  public interface OndatachannelCallbackFn {
    Object onInvoke(RTCDataChannelEvent p0);
  }

  @JsFunction
  public interface OnicecandidateCallbackFn {
    Object onInvoke(RTCPeerConnectionIceEvent p0);
  }

  @JsFunction
  public interface OniceconnectionstatechangeCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnnegotiationneededCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnremovestreamCallbackFn {
    Object onInvoke(MediaStreamEvent p0);
  }

  @JsFunction
  public interface OnsignalingstatechangeCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OntrackCallbackFn {
    Object onInvoke(RTCTrackEvent p0);
  }

  public static native Promise<RTCCertificate> generateCertificate(JsObject keygenAlgorithm);

  public String iceConnectionState;
  public String iceGatheringState;
  public RTCSessionDescription localDescription;
  public OnaddstreamCallbackFn onaddstream;
  public OndatachannelCallbackFn ondatachannel;
  public OnicecandidateCallbackFn onicecandidate;
  public OniceconnectionstatechangeCallbackFn oniceconnectionstatechange;
  public OnnegotiationneededCallbackFn onnegotiationneeded;
  public OnremovestreamCallbackFn onremovestream;
  public OnsignalingstatechangeCallbackFn onsignalingstatechange;
  public OntrackCallbackFn ontrack;
  public RTCSessionDescription remoteDescription;
  public String signalingState;

  public RTCPeerConnection(RTCConfigurationRecord_ configuration, JsObject constraints) {}

  public RTCPeerConnection(RTCConfigurationRecord_ configuration) {}

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType useCapture);

  public native void addEventListener(String type, EventListener listener);

  public native Promise addIceCandidate(
      RTCIceCandidate candidate,
      RTCVoidCallback successCallback,
      AddIceCandidateFailureCallbackFn failureCallback);

  public native Promise addIceCandidate(RTCIceCandidate candidate, RTCVoidCallback successCallback);

  public native Promise addIceCandidate(RTCIceCandidate candidate);

  public native void addStream(MediaStream stream, JsObject constraints);

  public native void addStream(MediaStream stream);

  public native RTCRtpSender addTrack(
      MediaStreamTrack track, MediaStream stream, MediaStream... var_args);

  public native Object close();

  public native Promise<RTCSessionDescription> createAnswer();

  public native Promise<RTCSessionDescription> createAnswer(
      JsObject successCallbackOrConstraints,
      RTCPeerConnectionErrorCallback failureCallback,
      JsObject constraints);

  public native Promise<RTCSessionDescription> createAnswer(
      JsObject successCallbackOrConstraints, RTCPeerConnectionErrorCallback failureCallback);

  public native Promise<RTCSessionDescription> createAnswer(JsObject successCallbackOrConstraints);

  public native RTCDataChannel createDataChannel(
      String label, RTCDataChannelInitRecord_ dataChannelDict);

  public native RTCDataChannel createDataChannel(String label);

  public native Promise<RTCSessionDescription> createOffer();

  public native Promise<RTCSessionDescription> createOffer(
      JsObject successCallbackOrConstraints,
      RTCPeerConnectionErrorCallback failureCallback,
      JsObject constraints);

  public native Promise<RTCSessionDescription> createOffer(
      JsObject successCallbackOrConstraints, RTCPeerConnectionErrorCallback failureCallback);

  public native Promise<RTCSessionDescription> createOffer(JsObject successCallbackOrConstraints);

  public native boolean dispatchEvent(Event evt);

  public native MediaStream[] getLocalStreams();

  public native MediaStream[] getRemoteStreams();

  public native RTCRtpSender[] getSenders();

  public native RTCStatsReport getStats();

  public native RTCStatsReport getStats(
      RTCStatsCallback successCallback, MediaStreamTrack selector);

  public native RTCStatsReport getStats(RTCStatsCallback successCallback);

  public native MediaStream getStreamById(String streamId);

  public native void removeEventListener(
      String type,
      EventListener listener,
      EventTarget.RemoveEventListenerOptionsUnionType useCapture);

  public native void removeEventListener(String type, EventListener listener);

  public native void removeStream(MediaStream stream);

  public native void removeTrack(RTCRtpSender sender);

  public native Promise<RTCSessionDescription> setLocalDescription(
      RTCSessionDescription description,
      RTCVoidCallback successCallback,
      RTCPeerConnectionErrorCallback failureCallback);

  public native Promise<RTCSessionDescription> setLocalDescription(
      RTCSessionDescription description, RTCVoidCallback successCallback);

  public native Promise<RTCSessionDescription> setLocalDescription(
      RTCSessionDescription description);

  public native Promise<RTCSessionDescription> setRemoteDescription(
      RTCSessionDescription description,
      RTCVoidCallback successCallback,
      RTCPeerConnectionErrorCallback failureCallback);

  public native Promise<RTCSessionDescription> setRemoteDescription(
      RTCSessionDescription description, RTCVoidCallback successCallback);

  public native Promise<RTCSessionDescription> setRemoteDescription(
      RTCSessionDescription description);

  public native void updateIce();

  public native void updateIce(RTCConfigurationRecord_ configuration, JsObject constraints);

  public native void updateIce(RTCConfigurationRecord_ configuration);
}
