/*
 * Decompiled with CFR 0.152.
 */
package com.google.enterprise.connector.logging;

import com.google.enterprise.connector.logging.MDC;
import com.google.enterprise.connector.logging.NDC;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LayoutPattern {
    private static final String NL = System.getProperty("line.separator");
    private FormatElement[] formatElements;
    private Formatter baseFormatter;

    public LayoutPattern(String format) {
        this(format, null);
    }

    public LayoutPattern(String format, Formatter baseFormatter) {
        this.baseFormatter = baseFormatter;
        this.parse(format);
    }

    private void parse(String format) {
        ArrayList<FormatElement> elems = new ArrayList<FormatElement>();
        if (format != null && format.length() > 0) {
            String[] strs = format.split("%", -1);
            boolean inConversion = false;
            for (int i = 0; i < strs.length; ++i) {
                String str = strs[i];
                int strLen = str.length();
                if (!inConversion) {
                    if (strLen > 0) {
                        elems.add(new StringElement(str));
                    }
                    inConversion = true;
                    continue;
                }
                if (strLen == 0) {
                    elems.add(new StringElement("%"));
                    inConversion = false;
                    continue;
                }
                int skipCount = 0;
                while ("-0123456789.".indexOf(str.charAt(skipCount)) >= 0) {
                    ++skipCount;
                }
                String modifier = skipCount > 0 ? str.substring(0, skipCount) : null;
                FormatElement elem = null;
                String arg = null;
                switch (str.charAt(skipCount++)) {
                    case 'C': {
                        arg = this.getArg(str, skipCount, strLen);
                        if (arg != null) {
                            elem = new ClassNameElement(Integer.parseInt(arg));
                            skipCount += arg.length() + 2;
                            break;
                        }
                        elem = new ClassNameElement();
                        break;
                    }
                    case 'd': {
                        arg = this.getArg(str, skipCount, strLen);
                        if (arg != null) {
                            elem = new DateElement(arg);
                            skipCount += arg.length() + 2;
                            break;
                        }
                        elem = new DateElement();
                        break;
                    }
                    case 'f': {
                        if (this.baseFormatter == null) {
                            throw new IllegalArgumentException("%f format conversion requires a base Formatter");
                        }
                        elem = new FormattedRecordElement();
                        break;
                    }
                    case 'M': {
                        elem = new MethodNameElement();
                        break;
                    }
                    case 'm': {
                        elem = new MessageElement();
                        break;
                    }
                    case 'N': {
                        elem = new SequenceNumberElement();
                        break;
                    }
                    case 'n': {
                        elem = new StringElement(NL);
                        break;
                    }
                    case 'p': {
                        elem = new LevelElement();
                        break;
                    }
                    case 'T': {
                        elem = new ThreadIdElement();
                        break;
                    }
                    case 't': {
                        elem = new ThreadNameElement();
                        break;
                    }
                    case 'x': {
                        elem = new NDCElement();
                        break;
                    }
                    case 'X': {
                        arg = this.getArg(str, skipCount, strLen);
                        if (arg != null) {
                            elem = new MDCElement(arg);
                            skipCount += arg.length() + 2;
                            break;
                        }
                        throw new IllegalArgumentException("MDC format conversion must specify key " + str.substring(skipCount));
                    }
                }
                if (elem != null) {
                    if (modifier != null) {
                        elem = new ModifierElement(modifier, elem);
                    }
                    elems.add(elem);
                }
                if (skipCount >= strLen) continue;
                elems.add(new StringElement(str.substring(skipCount)));
            }
        }
        this.formatElements = elems.toArray(new FormatElement[elems.size()]);
    }

    private String getArg(String str, int off, int len) {
        int end;
        if (off < len && str.charAt(off) == '{' && (end = str.indexOf(125, off + 1)) > 0) {
            return str.substring(off + 1, end);
        }
        return null;
    }

    public String format(LogRecord logRecord) {
        StringBuilder str = new StringBuilder();
        for (FormatElement elem : this.formatElements) {
            elem.format(str, logRecord);
        }
        return str.toString();
    }

    private class NDCElement
    implements FormatElement {
        private NDCElement() {
        }

        public void format(StringBuilder builder, LogRecord ignored) {
            builder.append(NDC.peek());
        }
    }

    private class MDCElement
    implements FormatElement {
        private String key;

        public MDCElement(String key) {
            this.key = key;
        }

        public void format(StringBuilder builder, LogRecord ignored) {
            builder.append(MDC.get(this.key));
        }
    }

    private class ThreadNameElement
    implements FormatElement {
        private ThreadNameElement() {
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            builder.append(Thread.currentThread().getName());
        }
    }

    private class ThreadIdElement
    implements FormatElement {
        private ThreadIdElement() {
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            builder.append(Thread.currentThread().getId());
        }
    }

    private class LevelElement
    implements FormatElement {
        private LevelElement() {
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            builder.append(logRecord.getLevel().getName());
        }
    }

    private class SequenceNumberElement
    implements FormatElement {
        private SequenceNumberElement() {
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            builder.append(logRecord.getSequenceNumber());
        }
    }

    private class MessageElement
    implements FormatElement {
        private MessageElement() {
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            if (LayoutPattern.this.baseFormatter == null) {
                builder.append(logRecord.getMessage());
            } else {
                builder.append(LayoutPattern.this.baseFormatter.formatMessage(logRecord));
            }
        }
    }

    private class MethodNameElement
    implements FormatElement {
        private MethodNameElement() {
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            builder.append(logRecord.getSourceMethodName());
        }
    }

    private class FormattedRecordElement
    implements FormatElement {
        private FormattedRecordElement() {
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            if (LayoutPattern.this.baseFormatter != null) {
                builder.append(LayoutPattern.this.baseFormatter.format(logRecord));
            }
        }
    }

    private class DateElement
    implements FormatElement {
        private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd' 'HH:mm:ss";
        private SimpleDateFormat dateFormat;

        public DateElement() {
            this(DEFAULT_DATE_FORMAT);
        }

        public DateElement(String dateFormat) {
            this.dateFormat = new SimpleDateFormat(dateFormat);
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            builder.append(this.dateFormat.format(new Date(logRecord.getMillis())));
        }
    }

    private class ClassNameElement
    implements FormatElement {
        private int segments = 0;

        public ClassNameElement() {
        }

        public ClassNameElement(int numSegments) {
            this.segments = numSegments;
        }

        public void format(StringBuilder builder, LogRecord logRecord) {
            String name = logRecord.getSourceClassName();
            if (this.segments > 0) {
                int start = name.length();
                for (int i = 0; i < this.segments; ++i) {
                    if ((start = name.lastIndexOf(46, start - 1)) >= 0) continue;
                    builder.append(name);
                    return;
                }
                builder.append(name.substring(start + 1));
            } else {
                builder.append(name);
            }
        }
    }

    private class StringElement
    implements FormatElement {
        private String string;

        public StringElement(String string) {
            this.string = string;
        }

        public void format(StringBuilder builder, LogRecord ignored) {
            builder.append(this.string);
        }
    }

    private class ModifierElement
    implements FormatElement {
        private boolean leftJustified;
        private int minWidth;
        private int maxWidth;
        private FormatElement base;

        public ModifierElement(String modifier, FormatElement base) {
            this.base = base;
            this.parse(modifier);
        }

        private void parse(String modifier) {
            int start;
            if (modifier.charAt(0) == '-') {
                this.leftJustified = true;
                start = 1;
            } else {
                this.leftJustified = false;
                start = 0;
            }
            int dotPos = modifier.indexOf(46);
            try {
                this.minWidth = dotPos < 0 ? Integer.parseInt(modifier.substring(start)) : Integer.parseInt(modifier.substring(start, dotPos));
            }
            catch (NumberFormatException nfe) {
                this.minWidth = 0;
            }
            this.maxWidth = Integer.MAX_VALUE;
            if (dotPos >= 0 && dotPos < modifier.length()) {
                try {
                    this.maxWidth = Integer.parseInt(modifier.substring(dotPos + 1));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }

        public void format(StringBuilder builder, LogRecord record) {
            int len;
            StringBuilder baseBuilder = new StringBuilder();
            this.base.format(baseBuilder, record);
            if (len >= this.minWidth && len <= this.maxWidth) {
                builder.append((CharSequence)baseBuilder);
            } else if (len < this.minWidth) {
                if (this.leftJustified) {
                    builder.append((CharSequence)baseBuilder);
                    for (len = baseBuilder.length(); len < this.minWidth; ++len) {
                        builder.append(' ');
                    }
                } else {
                    while (len < this.minWidth) {
                        builder.append(' ');
                        ++len;
                    }
                    builder.append((CharSequence)baseBuilder);
                }
            } else {
                builder.append(baseBuilder, 0, this.maxWidth);
            }
        }
    }

    private static interface FormatElement {
        public void format(StringBuilder var1, LogRecord var2);
    }
}

