/*
 * Decompiled with CFR 0.152.
 */
package com.google.enterprise.connector.logging;

import java.util.EmptyStackException;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDC {
    private static final String EMPTY_STRING = "";
    private static final ThreadLocal<Stack<String>> stack = new ThreadLocal();

    public static void clear() {
        NDC.getContextStack().clear();
    }

    public static int getDepth() {
        return NDC.getContextStack().size();
    }

    public static void push(String message) {
        NDC.getContextStack().push(message);
    }

    public static void pushAppend(String message) {
        String current = NDC.peek();
        if (current.length() > 0) {
            NDC.push(current + " " + message);
        } else {
            NDC.push(message);
        }
    }

    public static String peek() {
        try {
            return NDC.getContextStack().peek();
        }
        catch (EmptyStackException e) {
            return EMPTY_STRING;
        }
    }

    public static String pop() {
        try {
            return NDC.getContextStack().pop();
        }
        catch (EmptyStackException e) {
            return EMPTY_STRING;
        }
    }

    public static void remove() {
        stack.remove();
    }

    private static Stack<String> getContextStack() {
        Stack<String> ndcStack = stack.get();
        if (ndcStack == null) {
            ndcStack = new Stack();
            stack.set(ndcStack);
        }
        return ndcStack;
    }
}

