/*
 * Decompiled with CFR 0.152.
 */
package com.google.enterprise.connector.logging;

import com.google.enterprise.connector.logging.LayoutPattern;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends java.util.logging.SimpleFormatter {
    private final String DEFAULT_PATTERN = "%d{MMM dd, yyyy h:mm:ss a} [%x] %C %M%n%p: %m%n";
    private LayoutPattern layout;

    public SimpleFormatter() {
        String propName = this.getClass().getName() + ".format";
        String format = LogManager.getLogManager().getProperty(propName);
        if (format == null || format.trim().length() == 0) {
            format = "%d{MMM dd, yyyy h:mm:ss a} [%x] %C %M%n%p: %m%n";
        }
        this.layout = new LayoutPattern(format, new java.util.logging.SimpleFormatter());
    }

    public String format(LogRecord record) {
        String output = this.layout.format(record);
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            thrown.printStackTrace(pw);
            pw.flush();
            output = output + sw.toString();
            pw.close();
        }
        return output;
    }
}

