/*
 * Decompiled with CFR 0.152.
 */
package com.google.enterprise.connector.logging;

import com.google.enterprise.connector.logging.NDC;
import com.google.enterprise.connector.logging.SimpleFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;

public class XmlFormatter
extends Formatter {
    private static final String NL = System.getProperty("line.separator");
    private static final String RECORD_TAG = "<record>";
    private static final int RECORD_TAG_LEN = "<record>".length();
    private static final String EVENT_TAG = "log4j:event";
    private static final String LOCATION_TAG = "log4j:locationInfo";
    private static final String MESSAGE_TAG = "log4j:message";
    private static final String NDC_TAG = "log4j:NDC";
    private static final String THROWABLE_TAG = "log4j:throwable";
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private Formatter formatter = null;

    public XmlFormatter() {
        String propName = this.getClass().getName() + ".format";
        String format = LogManager.getLogManager().getProperty(propName);
        if (format != null && format.trim().length() > 0 && ("log4j".equals(format = format.trim().toLowerCase()) || "chainsaw".equals(format))) {
            this.formatter = new Log4jXmlFormatter();
        }
        if (this.formatter == null) {
            this.formatter = new UtilLoggingXmlFormatter();
        }
    }

    public String format(LogRecord record) {
        return this.formatter.format(record);
    }

    private static void appendAttr(StringBuilder buf, String attr, String value) {
        if (value != null && value.length() > 0) {
            buf.append(' ').append(attr).append("=\"");
            XmlFormatter.appendAttrValue(buf, value);
            buf.append('\"');
        }
    }

    private static void appendAttrValue(StringBuilder buf, String attrValue) {
        block7: for (int i = 0; i < attrValue.length(); ++i) {
            char c = attrValue.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    buf.append(' ');
                    continue block7;
                }
                default: {
                    if (c < ' ' || c > '\ufffd') continue block7;
                    buf.append(c);
                }
            }
        }
    }

    private static void appendCdata(StringBuilder buf, String tag, String str) {
        if (str.indexOf(CDATA_START) >= 0) {
            str = str.replaceAll(CDATA_START, " ");
        }
        if (str.indexOf(CDATA_END) >= 0) {
            str = str.replaceAll(CDATA_END, " ");
        }
        buf.append('<').append(tag).append('>');
        buf.append(CDATA_START).append(str).append(CDATA_END);
        buf.append("</").append(tag).append('>').append(NL);
    }

    private static class Log4jXmlFormatter
    extends SimpleFormatter {
        private Log4jXmlFormatter() {
        }

        public String format(LogRecord record) {
            StringBuilder buf = new StringBuilder();
            buf.append('<').append(XmlFormatter.EVENT_TAG);
            XmlFormatter.appendAttr(buf, "logger", record.getLoggerName());
            XmlFormatter.appendAttr(buf, "timestamp", Long.toString(record.getMillis()));
            XmlFormatter.appendAttr(buf, "level", record.getLevel().getName());
            XmlFormatter.appendAttr(buf, "thread", Thread.currentThread().getName());
            buf.append('>').append(NL);
            String ndc = NDC.peek();
            if (ndc != null && ndc.length() > 0) {
                XmlFormatter.appendCdata(buf, XmlFormatter.NDC_TAG, ndc);
            }
            buf.append('<').append(XmlFormatter.LOCATION_TAG);
            XmlFormatter.appendAttr(buf, "class", record.getSourceClassName());
            XmlFormatter.appendAttr(buf, "method", record.getSourceMethodName());
            buf.append(" file=\"\" line=\"\"/>").append(NL);
            XmlFormatter.appendCdata(buf, XmlFormatter.MESSAGE_TAG, super.formatMessage(record));
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                thrown.printStackTrace(pw);
                pw.flush();
                XmlFormatter.appendCdata(buf, XmlFormatter.THROWABLE_TAG, sw.toString());
                pw.close();
            }
            buf.append("</").append(XmlFormatter.EVENT_TAG).append('>').append(NL).append(NL);
            return buf.toString();
        }
    }

    private static class UtilLoggingXmlFormatter
    extends XMLFormatter {
        private UtilLoggingXmlFormatter() {
        }

        public String format(LogRecord record) {
            int point;
            String output = super.format(record);
            String ndc = NDC.peek();
            if (ndc != null && ndc.length() > 0 && (point = output.indexOf(XmlFormatter.RECORD_TAG)) >= 0) {
                point += RECORD_TAG_LEN;
                if (ndc.indexOf(38) >= 0) {
                    ndc = ndc.replaceAll("&", "&amp;");
                }
                if (ndc.indexOf(60) >= 0) {
                    ndc = ndc.replaceAll("<", "&lt;");
                }
                if (ndc.indexOf(62) >= 0) {
                    ndc = ndc.replaceAll(">", "&gt;");
                }
                output = output.substring(0, point) + NL + "  <ndc>" + ndc + "</ndc>" + output.substring(point);
            }
            return output;
        }
    }
}

