/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.http.GenericUrl;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ApiEndpoints {
    private static final String API_URL = System.getProperty("FIREBASE_APP_DISTRIBUTION_API_URL", "https://firebaseappdistribution.googleapis.com");
    public static final List<String> SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform");

    static GenericUrl getDistributeReleaseEndpoint(String releaseName) {
        return new GenericUrl(String.format("%s/v1/%s:distribute", API_URL, releaseName));
    }

    static GenericUrl getCreateReleaseNotesEndpoint(String releaseName) {
        return new GenericUrl(String.format("%s/v1/%s?updateMask=release_notes.text", API_URL, releaseName));
    }

    static GenericUrl getUploadStatusEndpoint(String operationName) {
        return new GenericUrl(String.format("%s/v1/%s", API_URL, operationName));
    }

    static GenericUrl getAabInfo(String appName) {
        return new GenericUrl(String.format("%s/v1/%s/aabInfo", API_URL, appName));
    }

    static GenericUrl getScottyUploadEndpoint(String appName) {
        return new GenericUrl(String.format("%s/upload/v1/%s/releases:upload", API_URL, appName));
    }

    static GenericUrl getBatchAddTestersEndpoint(long projectNumber) {
        return new GenericUrl(String.format("%s/v1/projects/%s/testers:batchAdd", API_URL, projectNumber));
    }

    static GenericUrl getBatchRemoveTestersEndpoint(long projectNumber) {
        return new GenericUrl(String.format("%s/v1/projects/%s/testers:batchRemove", API_URL, projectNumber));
    }

    static GenericUrl getCreateReleaseTestEndpoint(String releaseName) {
        return new GenericUrl(String.format("%s/v1alpha/%s/tests", API_URL, releaseName));
    }

    static GenericUrl getReleaseTestEndpoint(String releaseTestName) {
        return new GenericUrl(String.format("%s/v1alpha/%s", API_URL, releaseTestName));
    }
}

