/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.firebase.appdistribution.gradle.ApiEndpoints;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.AppDistributionLogger;
import com.google.firebase.appdistribution.gradle.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.gradle.AuthenticatedHttpClient;
import com.google.firebase.appdistribution.gradle.BinaryType;
import com.google.firebase.appdistribution.gradle.models.AabInfo;
import com.google.firebase.appdistribution.gradle.models.DeviceExecution;
import com.google.firebase.appdistribution.gradle.models.LoginCredential;
import com.google.firebase.appdistribution.gradle.models.ReleaseTest;
import com.google.firebase.appdistribution.gradle.models.TestDevice;
import com.google.firebase.appdistribution.gradle.models.uploadstatus.UploadStatusResponse;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class ApiService {
    private static final int MAX_TESTER_EMAILS = 1000;
    AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();
    private final AuthenticatedHttpClient httpClient;

    ApiService(AuthenticatedHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    UploadStatusResponse getUploadStatus(String operationName, BinaryType binaryType) throws AppDistributionException {
        GenericUrl endpoint = ApiEndpoints.getUploadStatusEndpoint(operationName);
        try {
            HttpResponse response = this.httpClient.newGetRequest(endpoint).execute();
            return (UploadStatusResponse)new Gson().fromJson(response.parseAsString(), UploadStatusResponse.class);
        }
        catch (HttpResponseException e) {
            throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.processingBinaryError(binaryType), e);
        }
        catch (IOException e) {
            throw AppDistributionException.fromIoException(AppDistributionException.Reason.processingBinaryError(binaryType), e);
        }
    }

    boolean createReleaseNotes(String releaseName, String releaseNotes) throws IOException {
        JsonObject jsonBody = this.buildCreateReleaseNotesJson(releaseName, releaseNotes);
        ByteArrayContent content = new ByteArrayContent("application/json", jsonBody.toString().getBytes(StandardCharsets.UTF_8));
        HttpResponse createReleaseNotesResponse = this.httpClient.newPatchRequest(ApiEndpoints.getCreateReleaseNotesEndpoint(releaseName), (HttpContent)content).execute();
        if (createReleaseNotesResponse.isSuccessStatusCode()) {
            this.LOGGER.info("Added release notes successfully %s", createReleaseNotesResponse.getStatusCode());
            return true;
        }
        this.LOGGER.info("Unable to add release notes. Response code: %s", createReleaseNotesResponse.getStatusCode());
        return false;
    }

    boolean distributeRelease(String releaseName, List<String> emails, List<String> groupIds) throws IOException {
        JsonObject jsonBody = this.buildDistributeReleaseJson(releaseName, emails, groupIds);
        HttpResponse distributeReleaseResponse = this.httpClient.newPostRequest(ApiEndpoints.getDistributeReleaseEndpoint(releaseName), (HttpContent)this.buildHttpContent((JsonElement)jsonBody)).execute();
        if (distributeReleaseResponse.isSuccessStatusCode()) {
            this.LOGGER.info("Added testers/groups successfully %s", distributeReleaseResponse.getStatusCode());
            return true;
        }
        this.LOGGER.info("Unable to add testers/groups. Response code: %s", distributeReleaseResponse.getStatusCode());
        return false;
    }

    public ReleaseTest testRelease(String releaseName, List<TestDevice> testDevices, LoginCredential testLoginCredential) throws IOException {
        ReleaseTest releaseTest = new ReleaseTest().setLoginCredential(testLoginCredential).setDeviceExecutions(testDevices.stream().map(device -> new DeviceExecution().setDevice((TestDevice)device)).collect(Collectors.toList()));
        HttpResponse response = this.httpClient.newPostRequest(ApiEndpoints.getCreateReleaseTestEndpoint(releaseName), (HttpContent)this.buildHttpContent(new Gson().toJsonTree((Object)releaseTest))).execute();
        if (response.isSuccessStatusCode()) {
            this.LOGGER.info("Started test successfully %s. Note: This feature is in beta.", response.getStatusCode());
            return (ReleaseTest)new Gson().fromJson(response.parseAsString(), ReleaseTest.class);
        }
        this.LOGGER.warn("Unable to start test. Response code: %s", response.getStatusCode());
        return null;
    }

    public ReleaseTest getReleaseTest(String releaseTestName) throws IOException {
        HttpResponse response = this.httpClient.newGetRequest(ApiEndpoints.getReleaseTestEndpoint(releaseTestName)).execute();
        if (response.isSuccessStatusCode()) {
            return (ReleaseTest)new Gson().fromJson(response.parseAsString(), ReleaseTest.class);
        }
        this.LOGGER.warn("Unable to retrieve test. Response code: %s", response.getStatusCode());
        return null;
    }

    AabInfo getAabInfo(String appName) throws IOException {
        HttpResponse appResponse = this.httpClient.newGetRequest(ApiEndpoints.getAabInfo(appName)).execute();
        return (AabInfo)new Gson().fromJson(appResponse.parseAsString(), AabInfo.class);
    }

    boolean batchAddTesters(long projectNumber, Collection<String> emails) throws IOException {
        if (emails.size() > 1000) {
            throw new AppDistributionException(AppDistributionException.Reason.TOO_MANY_TESTER_EMAILS, String.format("Cannot add %s testers, %s is the maximum allowed", emails.size(), 1000));
        }
        this.LOGGER.info("Adding %s testers to project %s...", emails.size(), projectNumber);
        JsonObject jsonBody = this.buildTesterEmailsJson(emails);
        HttpResponse response = this.httpClient.newPostRequest(ApiEndpoints.getBatchAddTestersEndpoint(projectNumber)).setContent((HttpContent)this.buildHttpContent((JsonElement)jsonBody)).execute();
        if (response.isSuccessStatusCode()) {
            this.LOGGER.info("Testers added successfully [%s]", response.getStatusCode());
            return true;
        }
        this.LOGGER.info("Unable to add testers. Response code: %s", response.getStatusCode());
        return false;
    }

    boolean batchRemoveTesters(long projectNumber, Collection<String> emails) throws IOException {
        if (emails.size() > 1000) {
            throw new AppDistributionException(AppDistributionException.Reason.TOO_MANY_TESTER_EMAILS, String.format("Cannot remove %s testers, %s is the maximum allowed", emails.size(), 1000));
        }
        this.LOGGER.info("Removing %s testers from project %s...", emails.size(), projectNumber);
        JsonObject jsonBody = this.buildTesterEmailsJson(emails);
        HttpResponse response = this.httpClient.newPostRequest(ApiEndpoints.getBatchRemoveTestersEndpoint(projectNumber)).setContent((HttpContent)this.buildHttpContent((JsonElement)jsonBody)).execute();
        if (response.isSuccessStatusCode()) {
            JsonObject json = JsonParser.parseString((String)response.parseAsString()).getAsJsonObject();
            JsonElement emailsResponse = json.get("emails");
            JsonArray emailsRemoved = emailsResponse == null ? new JsonArray() : emailsResponse.getAsJsonArray();
            this.LOGGER.info("%s testers removed successfully [%s]", emailsRemoved.size(), response.getStatusCode());
            this.LOGGER.debug("Testers removed: %s", emailsRemoved);
            return true;
        }
        this.LOGGER.info("Unable to remove testers. Response code: %s", response.getStatusCode());
        return false;
    }

    protected JsonObject buildCreateReleaseNotesJson(String releaseName, String releaseNotes) {
        JsonObject jsonBody = new JsonObject();
        jsonBody.add("name", (JsonElement)new JsonPrimitive(releaseName));
        JsonObject releaseNotesJson = new JsonObject();
        releaseNotesJson.add("text", (JsonElement)new JsonPrimitive(releaseNotes));
        jsonBody.add("releaseNotes", (JsonElement)releaseNotesJson);
        return jsonBody;
    }

    protected JsonObject buildDistributeReleaseJson(String releaseName, List<String> emails, List<String> groupIds) {
        JsonObject jsonBody = new JsonObject();
        jsonBody.add("name", (JsonElement)new JsonPrimitive(releaseName));
        jsonBody.add("testerEmails", (JsonElement)this.buildJsonArray(emails));
        jsonBody.add("groupAliases", (JsonElement)this.buildJsonArray(groupIds));
        return jsonBody;
    }

    protected JsonObject buildTesterEmailsJson(Collection<String> emails) {
        JsonObject jsonBody = new JsonObject();
        jsonBody.add("emails", (JsonElement)this.buildJsonArray(emails));
        return jsonBody;
    }

    private JsonArray buildJsonArray(Collection<String> entities) {
        JsonArray jsonArray = new JsonArray();
        entities.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return jsonArray;
    }

    private ByteArrayContent buildHttpContent(JsonElement json) {
        return new ByteArrayContent("application/json", json.toString().getBytes(StandardCharsets.UTF_8));
    }
}

