/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpTransport;
import com.google.firebase.appdistribution.gradle.AppDistributionEnvironment;
import com.google.firebase.appdistribution.gradle.AppDistributionLogger;
import com.google.firebase.appdistribution.gradle.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.gradle.RefreshToken;
import com.google.firebase.appdistribution.gradle.models.FirebaseCliConfig;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class AppDistributionEnvironmentImpl
implements AppDistributionEnvironment {
    private static final AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();

    @Override
    public Optional<Credential> getFirebaseCliLoginCredentials(HttpTransport transport) {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Path configPath = System.getenv("XDG_CONFIG_HOME") != null ? Paths.get(System.getenv("XDG_CONFIG_HOME"), "configstore", "firebase-tools.json") : Paths.get(System.getProperty("user.home"), ".config", "configstore", "firebase-tools.json");
        try {
            JsonElement jsonElement = new JsonParser().parse((Reader)new FileReader(configPath.toString()));
            FirebaseCliConfig config = (FirebaseCliConfig)gson.fromJson(jsonElement.toString(), FirebaseCliConfig.class);
            if (config.getTokens() != null && config.getTokens().getRefreshToken() != null) {
                RefreshToken refreshToken = new RefreshToken(config.getTokens().getRefreshToken(), transport);
                return Optional.of(refreshToken.generateNewCredential());
            }
            return Optional.empty();
        }
        catch (IOException e) {
            LOGGER.debug("Failed to authenticate with Firebase CLI credentials %s", e);
            return Optional.empty();
        }
    }
}

