/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.http.HttpResponseException;
import com.google.firebase.appdistribution.gradle.AppDistributionLogger;
import com.google.firebase.appdistribution.gradle.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.gradle.BinaryType;
import com.google.firebase.appdistribution.gradle.models.AabState;
import com.google.firebase.appdistribution.gradle.models.WrappedErrorResponse;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import javax.annotation.Nullable;

public class AppDistributionException
extends RuntimeException {
    private static final AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();
    private final Reason reason;

    public Reason getReason() {
        return this.reason;
    }

    AppDistributionException(Reason reason) {
        super(reason.getMessage());
        this.reason = reason;
    }

    AppDistributionException(Reason reason, Throwable cause) {
        this(reason, cause.getMessage(), cause);
    }

    AppDistributionException(Reason reason, String extraInformation) {
        super(AppDistributionException.formatMessage(reason, extraInformation));
        this.reason = reason;
    }

    private AppDistributionException(Reason reason, String extraInformation, Throwable cause) {
        super(AppDistributionException.formatMessage(reason, extraInformation), cause);
        this.reason = reason;
    }

    private AppDistributionException(Reason reason, Reason subReason) {
        super(AppDistributionException.formatMessage(reason, subReason.getMessage()));
        this.reason = reason;
    }

    public static String formatMessage(Reason reason, String extraInformation) {
        return String.format("%s: %s", reason.getMessage(), extraInformation);
    }

    private static String getParsedMessageOrStatusMessage(HttpResponseException exception) {
        String message = exception.getStatusMessage();
        try {
            WrappedErrorResponse response = (WrappedErrorResponse)new Gson().fromJson(exception.getContent(), WrappedErrorResponse.class);
            if (response != null && response.getError() != null) {
                message = response.getError().getMessage();
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.info(String.format("Failed to parse error response %s", exception.getStatusMessage()), new Object[0]);
        }
        return message;
    }

    public static AppDistributionException fromIoException(Reason reason, IOException cause) {
        return new AppDistributionException(reason, cause.getMessage(), cause);
    }

    public static AppDistributionException fromHttpResponseException(Reason reason, HttpResponseException cause) {
        return new AppDistributionException(reason, String.format("[%d] %s", cause.getStatusCode(), AppDistributionException.getParsedMessageOrStatusMessage(cause)), cause);
    }

    public static AppDistributionException forAabState(@Nullable AabState state) {
        Reason reason;
        if (state == null) {
            return new AppDistributionException(Reason.AAB_PROCESSING_ERROR);
        }
        switch (state) {
            case APP_NOT_PUBLISHED: {
                reason = Reason.AAB_APP_ERROR_APP_NOT_PUBLISHED;
                break;
            }
            case NO_APP_WITH_GIVEN_BUNDLE_ID_IN_PLAY_ACCOUNT: {
                reason = Reason.AAB_APP_ERROR_NO_APP_WITH_GIVEN_BUNDLE_ID_IN_PLAY_ACCOUNT;
                break;
            }
            case PLAY_ACCOUNT_NOT_LINKED: {
                reason = Reason.AAB_APP_ERROR_PLAY_ACCOUNT_NOT_LINKED;
                break;
            }
            case PLAY_IAS_TERMS_NOT_ACCEPTED: {
                reason = Reason.AAB_APP_ERROR_TOS_NOT_ACCEPTED;
                break;
            }
            default: {
                return new AppDistributionException(Reason.AAB_PROCESSING_ERROR);
            }
        }
        return new AppDistributionException(Reason.AAB_PROCESSING_ERROR, reason);
    }

    public static enum Reason {
        MISSING_CREDENTIALS("Missing credentials. Please check that a refresh token was set or service credentials were passed in and try again"),
        APK_NOT_FOUND("Could not find the APK. Make sure you build first by running ./gradlew assemble[Variant], or set the artifactPath parameter to point to your APK"),
        AAB_NOT_FOUND("Could not find the AAB. Make sure you build first by running ./gradlew bundle[Variant], or set the artifactPath parameter to point to your AAB"),
        BINARY_NOT_FOUND("Could not find the APK or AAB. Make sure you build first by running ./gradlew assemble[Variant], ./gradlew bundle[Variant], or set the artifactPath parameter to point to your APK or AAB"),
        MISSING_PROJECT_NUMBER("Missing project number. Please check that it was passed in and try again"),
        MISSING_APP_ID("Missing app id. Please check that it was passed in and try again"),
        INVALID_APP_ID("Invalid app id. Please check that the correct id was passed in and try again"),
        MISSING_TESTER_EMAILS("Missing tester emails. Please check that they were passed in and try again"),
        SERVICE_CREDENTIALS_NOT_FOUND("Service credentials file does not exist. Please check the service credentials path and try again"),
        UPLOAD_RELEASE_NOTES_ERROR("App Distribution halted because it had a problem uploading release notes"),
        UPLOAD_TESTERS_ERROR("App Distribution halted because it had a problem adding testers/groups"),
        UPLOAD_AAB_ERROR("App Distribution halted because it had a problem uploading the AAB"),
        UPLOAD_APK_ERROR("App Distribution halted because it had a problem uploading the APK"),
        AAB_PROCESSING_ERROR("App Distribution failed to process the AAB"),
        APK_PROCESSING_ERROR("App Distribution failed to process the APK"),
        GET_RELEASE_TIMEOUT("App Distribution failed to fetch release information"),
        REFRESH_TOKEN_ERROR("Could not generate credentials from the refresh token specified"),
        GET_APP_ERROR("App Distribution failed to fetch app information"),
        APP_NOT_ONBOARDED_ERROR("App Distribution not onboarded"),
        AAB_APP_ERROR_APP_NOT_PUBLISHED("This app is not published in the Google Play console."),
        AAB_APP_ERROR_NO_APP_WITH_GIVEN_BUNDLE_ID_IN_PLAY_ACCOUNT("App with matching package name does not exist in Google Play."),
        AAB_APP_ERROR_PLAY_ACCOUNT_NOT_LINKED("This project is not linked to a Google Play account."),
        AAB_APP_ERROR_TOS_NOT_ACCEPTED("You must accept the Play Internal App Sharing (IAS) terms to upload AABs."),
        ADD_TESTERS_ERROR("App Distribution failed to add testers"),
        REMOVE_TESTERS_ERROR("App Distribution failed to remove testers"),
        TOO_MANY_TESTER_EMAILS("App Distribution could not perform the operation, too many tester emails"),
        TEST_LOGIN_CREDENTIAL_MISMATCH("Username and password for automated tests need to be specified together."),
        TEST_LOGIN_CREDENTIAL_RESOURCE_MISMATCH("Username and password resource names for automated tests need to be specified together."),
        TEST_LOGIN_CREDENTIAL_MISSING("Must specify username and password"),
        STARTING_TEST_FAILED("App Distribution could not perform the automated test."),
        GET_TEST_RETRIEVAL_FAILURE("App Distribution could not retrieve the test."),
        GET_TEST_TIMEOUT("It took longer than expected to process your test, please try again."),
        GET_TEST_FAILED("Automated test failed or was inconclusive.");

        private final String message;

        public static Reason uploadBinaryError(BinaryType binaryType) {
            return binaryType.equals((Object)BinaryType.AAB) ? UPLOAD_AAB_ERROR : UPLOAD_APK_ERROR;
        }

        public static Reason processingBinaryError(BinaryType binaryType) {
            return binaryType.equals((Object)BinaryType.AAB) ? AAB_PROCESSING_ERROR : APK_PROCESSING_ERROR;
        }

        public static Reason binaryNotFoundError(BinaryType binaryType) {
            return binaryType.equals((Object)BinaryType.AAB) ? AAB_NOT_FOUND : APK_NOT_FOUND;
        }

        private Reason(String message) {
            this.message = message;
        }

        String getMessage() {
            return this.message;
        }
    }
}

