/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.google.firebase.appdistribution.gradle.AddTestersTask;
import com.google.firebase.appdistribution.gradle.AppDistributionExtension;
import com.google.firebase.appdistribution.gradle.AppDistributionLogger;
import com.google.firebase.appdistribution.gradle.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.gradle.BuildVariantHelper;
import com.google.firebase.appdistribution.gradle.CliRuntimeProperties;
import com.google.firebase.appdistribution.gradle.ManifestReader;
import com.google.firebase.appdistribution.gradle.RemoveTestersTask;
import com.google.firebase.appdistribution.gradle.UploadDistributionTask;
import com.google.firebase.appdistribution.gradle.UploadDistributionTaskConfigurator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public final class AppDistributionPlugin
implements Plugin<Project> {
    private static AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();
    static final String EXTENSION_NAME = "firebaseAppDistribution";
    private static final String ANDROID_PLUGIN_ID = "com.android.application";
    private static final String ADD_TESTERS_TASK_NAME = "appDistributionAddTesters";
    private static final String REMOVE_TESTERS_TASK_NAME = "appDistributionRemoveTesters";
    private boolean foundAndroidPlugin = false;

    public void apply(Project project) {
        try {
            Class.forName("com.android.build.api.variant.ApplicationAndroidComponentsExtension");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOGGER.warn("Warning: The App Distribution Gradle plugin has deprecated support for versions of Android Gradle Plugin lower than 7.0.0. Support for these lower versions will be completely removed as early as April 2024.", new Object[0]);
        }
        project.getPluginManager().withPlugin(ANDROID_PLUGIN_ID, androidPlugin -> {
            this.foundAndroidPlugin = true;
            this.setUp(project);
        });
        project.afterEvaluate(unused -> {
            if (!this.foundAndroidPlugin) {
                throw new IllegalStateException("firebaseAppDistribution must only be used with Android application projects. Please apply the 'com.android.application' plugin.");
            }
        });
    }

    public static CliRuntimeProperties getClientProperties() {
        return CliRuntimeProperties.newBuilder().setClientVersion(ManifestReader.getVersionFromManifest()).build();
    }

    private void setUp(Project project) {
        project.getTasks().create(ADD_TESTERS_TASK_NAME, AddTestersTask.class);
        project.getTasks().create(REMOVE_TESTERS_TASK_NAME, RemoveTestersTask.class);
        project.getExtensions().add(EXTENSION_NAME, AppDistributionExtension.class);
        AppExtension androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        androidExt.getBuildTypes().all(buildType -> BuildVariantHelper.getExtensions(buildType).add(EXTENSION_NAME, AppDistributionExtension.class));
        androidExt.getProductFlavors().all(flavor -> BuildVariantHelper.getExtensions(flavor).add(EXTENSION_NAME, AppDistributionExtension.class));
        androidExt.getApplicationVariants().all(appVariant -> {
            String taskAffix = appVariant.getName().substring(0, 1).toUpperCase() + appVariant.getName().substring(1);
            AppDistributionExtension origExtension = (AppDistributionExtension)project.getProperties().get(EXTENSION_NAME);
            if (origExtension == null) {
                origExtension = new AppDistributionExtension();
            }
            Optional<BuildType> buildType = androidExt.getBuildTypes().stream().filter(extensionBuildType -> appVariant.getBuildType().getName().equals(extensionBuildType.getName())).findFirst();
            List<ProductFlavor> flavors = androidExt.getProductFlavors().stream().filter(extensionFlavor -> appVariant.getProductFlavors().stream().anyMatch(variantFlavor -> variantFlavor.getName().equals(extensionFlavor.getName()))).collect(Collectors.toList());
            AppDistributionExtension mergedExtension = origExtension.getMergedProperties(buildType.get(), flavors);
            project.getTasks().create(AppDistributionPlugin.uploadDistributionTaskName(taskAffix), UploadDistributionTask.class, task -> UploadDistributionTaskConfigurator.configure(task, appVariant, mergedExtension));
        });
    }

    private static String uploadDistributionTaskName(String taskAffix) {
        return String.format("appDistributionUpload%s", taskAffix);
    }
}

