/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.firebase.appdistribution.gradle.RequestBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

public class AuthenticatedHttpClient {
    private final HttpTransport httpTransport;
    private final HttpRequestInitializer httpRequestInitializer;

    public AuthenticatedHttpClient(Credential credential) throws GeneralSecurityException, IOException {
        this(AuthenticatedHttpClient.newGoogleHttpTransport(), (HttpRequestInitializer)credential);
    }

    public AuthenticatedHttpClient(HttpTransport httpTransport) {
        this(httpTransport, new DefaultHttpRequestInitializer());
    }

    public AuthenticatedHttpClient(HttpTransport httpTransport, HttpRequestInitializer requestInitializer) {
        this.httpTransport = httpTransport;
        this.httpRequestInitializer = requestInitializer;
    }

    public RequestBuilder newGetRequest(GenericUrl url) throws IOException {
        return new RequestBuilder(this.httpTransport.createRequestFactory(this.httpRequestInitializer).buildGetRequest(url));
    }

    public RequestBuilder newPostRequest(GenericUrl url) throws IOException {
        return this.newPostRequest(url, null);
    }

    public RequestBuilder newPostRequest(GenericUrl url, HttpContent content) throws IOException {
        return new RequestBuilder(this.httpTransport.createRequestFactory(this.httpRequestInitializer).buildPostRequest(url, content));
    }

    public RequestBuilder newPatchRequest(GenericUrl url, HttpContent content) throws IOException {
        return new RequestBuilder(this.httpTransport.createRequestFactory(this.httpRequestInitializer).buildPostRequest(url, content)).setHeader("X-Http-Method-Override", "PATCH");
    }

    static HttpTransport newGoogleHttpTransport() throws IOException, GeneralSecurityException {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        builder.trustCertificates(GoogleUtils.getCertificateTrustStore());
        String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        if (trustStorePath != null && trustStorePassword != null) {
            builder.trustCertificatesFromJavaKeyStore((InputStream)new FileInputStream(trustStorePath), trustStorePassword);
        }
        return builder.build();
    }

    static class DefaultHttpRequestInitializer
    implements HttpRequestInitializer {
        DefaultHttpRequestInitializer() {
        }

        public void initialize(HttpRequest request) {
        }
    }
}

