/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.appdistribution.gradle.AppDistributionEnvironment;
import com.google.firebase.appdistribution.gradle.AppDistributionEnvironmentImpl;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.OptionsUtils;
import com.google.firebase.appdistribution.gradle.RefreshToken;
import com.google.firebase.appdistribution.gradle.models.ServiceAccountCredentials;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;

public class CredentialsRetriever {
    private final HttpTransport httpTransport;
    private final AppDistributionEnvironment appDistributionEnvironment;

    @VisibleForTesting
    CredentialsRetriever() throws GeneralSecurityException, IOException {
        this((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), new AppDistributionEnvironmentImpl());
    }

    @VisibleForTesting
    CredentialsRetriever(HttpTransport httpTransport) {
        this(httpTransport, new AppDistributionEnvironmentImpl());
    }

    @VisibleForTesting
    CredentialsRetriever(AppDistributionEnvironment appDistributionEnvironment) throws GeneralSecurityException, IOException {
        this((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), appDistributionEnvironment);
    }

    public CredentialsRetriever(HttpTransport httpTransport, AppDistributionEnvironment appDistributionEnvironment) {
        this.httpTransport = httpTransport;
        this.appDistributionEnvironment = appDistributionEnvironment;
    }

    public Credential getAuthCredential(Optional<String> serviceCredentialsPath) {
        if (serviceCredentialsPath.isPresent()) {
            File serviceCredentialsFile = OptionsUtils.ensureFile(serviceCredentialsPath.get(), AppDistributionException.Reason.SERVICE_CREDENTIALS_NOT_FOUND);
            try {
                return ServiceAccountCredentials.fromFile(serviceCredentialsFile).getGoogleCredential();
            }
            catch (IOException e) {
                throw new AppDistributionException(AppDistributionException.Reason.SERVICE_CREDENTIALS_NOT_FOUND, (Throwable)e);
            }
        }
        String envRefreshToken = System.getenv("FIREBASE_TOKEN");
        if (envRefreshToken != null) {
            try {
                System.out.println(String.format("Using credentials token specified by environment variable %s", "FIREBASE_TOKEN"));
                return new RefreshToken(envRefreshToken, this.httpTransport).generateNewCredential();
            }
            catch (Exception e) {
                throw new AppDistributionException(AppDistributionException.Reason.REFRESH_TOKEN_ERROR, "The refresh token set as the environment variable FIREBASE_TOKEN is not valid");
            }
        }
        Optional<Credential> firebaseCliLoginCreds = this.appDistributionEnvironment.getFirebaseCliLoginCredentials(this.httpTransport);
        if (firebaseCliLoginCreds.isPresent()) {
            System.out.println("Using cached Firebase CLI credentials");
            return firebaseCliLoginCreds.get();
        }
        String envGoogleCredentialsPath = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
        if (envGoogleCredentialsPath != null) {
            System.out.println(String.format("Using credentials file specified by environment variable %s: %s", "GOOGLE_APPLICATION_CREDENTIALS", envGoogleCredentialsPath));
            File serviceCredentialsFile = OptionsUtils.ensureFile(envGoogleCredentialsPath, AppDistributionException.Reason.SERVICE_CREDENTIALS_NOT_FOUND);
            try {
                ServiceAccountCredentials envServiceAccountCredentials = ServiceAccountCredentials.fromFile(serviceCredentialsFile);
                return envServiceAccountCredentials.getGoogleCredential();
            }
            catch (IOException e) {
                throw new AppDistributionException(AppDistributionException.Reason.SERVICE_CREDENTIALS_NOT_FOUND, (Throwable)e);
            }
        }
        return null;
    }
}

