/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpResponseException;
import com.google.firebase.appdistribution.gradle.ApiService;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.AppDistributionLogger;
import com.google.firebase.appdistribution.gradle.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.gradle.AuthenticatedHttpClient;
import com.google.firebase.appdistribution.gradle.CliRuntime;
import com.google.firebase.appdistribution.gradle.CliRuntimeProperties;
import com.google.firebase.appdistribution.gradle.FirebaseAppDistributionUpload;
import com.google.firebase.appdistribution.gradle.TesterManagementOptions;
import com.google.firebase.appdistribution.gradle.UploadDistributionOptions;
import com.google.firebase.appdistribution.gradle.UploadService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;

public class FirebaseAppDistribution {
    public static void uploadDistribution(UploadDistributionOptions options, AppDistributionLogger logger, CliRuntimeProperties props) {
        AppDistributionLoggerHelper.setLogger(logger);
        FirebaseAppDistribution.setClientHeaders(props);
        if (options.getBinary() == null) {
            throw new AppDistributionException(AppDistributionException.Reason.BINARY_NOT_FOUND);
        }
        if (options.getAppId() == null) {
            throw new AppDistributionException(AppDistributionException.Reason.MISSING_APP_ID);
        }
        if (options.getCredentials() == null) {
            throw new AppDistributionException(AppDistributionException.Reason.MISSING_CREDENTIALS);
        }
        AuthenticatedHttpClient googleHttpClient = FirebaseAppDistribution.getAuthenticatedHttpClient(options.getCredentials());
        ApiService apiService = new ApiService(googleHttpClient);
        UploadService uploadService = new UploadService(googleHttpClient);
        FirebaseAppDistributionUpload upload = new FirebaseAppDistributionUpload(options, apiService, uploadService);
        upload.uploadDistribution();
    }

    public static void addTesters(TesterManagementOptions options, AppDistributionLogger logger, CliRuntimeProperties props) {
        AppDistributionLoggerHelper.setLogger(logger);
        FirebaseAppDistribution.setClientHeaders(props);
        AuthenticatedHttpClient googleHttpClient = FirebaseAppDistribution.getAuthenticatedHttpClient(options.getCredentials());
        ApiService apiService = new ApiService(googleHttpClient);
        try {
            apiService.batchAddTesters(options.getProjectNumber(), (Collection<String>)options.getEmails());
        }
        catch (HttpResponseException e) {
            throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.ADD_TESTERS_ERROR, e);
        }
        catch (IOException e) {
            throw AppDistributionException.fromIoException(AppDistributionException.Reason.ADD_TESTERS_ERROR, e);
        }
    }

    public static void removeTesters(TesterManagementOptions options, AppDistributionLogger logger, CliRuntimeProperties props) {
        AppDistributionLoggerHelper.setLogger(logger);
        FirebaseAppDistribution.setClientHeaders(props);
        AuthenticatedHttpClient googleHttpClient = FirebaseAppDistribution.getAuthenticatedHttpClient(options.getCredentials());
        ApiService apiService = new ApiService(googleHttpClient);
        try {
            apiService.batchRemoveTesters(options.getProjectNumber(), (Collection<String>)options.getEmails());
        }
        catch (HttpResponseException e) {
            throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.REMOVE_TESTERS_ERROR, e);
        }
        catch (IOException e) {
            throw AppDistributionException.fromIoException(AppDistributionException.Reason.REMOVE_TESTERS_ERROR, e);
        }
    }

    private static void setClientHeaders(CliRuntimeProperties props) {
        CliRuntime.getInstance().setClientVersion(props.getClientVersion());
    }

    private static AuthenticatedHttpClient getAuthenticatedHttpClient(Credential credential) {
        try {
            return new AuthenticatedHttpClient(credential);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("There was a problem. Please try again.", e);
        }
    }
}

