/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.http.HttpResponseException;
import com.google.common.base.Strings;
import com.google.firebase.appdistribution.gradle.ApiService;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.AppDistributionLogger;
import com.google.firebase.appdistribution.gradle.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.gradle.BinaryType;
import com.google.firebase.appdistribution.gradle.ReleaseLookup;
import com.google.firebase.appdistribution.gradle.TestLookup;
import com.google.firebase.appdistribution.gradle.UploadDistributionOptions;
import com.google.firebase.appdistribution.gradle.UploadService;
import com.google.firebase.appdistribution.gradle.models.AabInfo;
import com.google.firebase.appdistribution.gradle.models.AabState;
import com.google.firebase.appdistribution.gradle.models.ReleaseTest;
import com.google.firebase.appdistribution.gradle.models.TestDevice;
import com.google.firebase.appdistribution.gradle.models.uploadstatus.Release;
import com.google.firebase.appdistribution.gradle.models.uploadstatus.UploadStatusResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class FirebaseAppDistributionUpload {
    AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();
    private final UploadDistributionOptions options;
    private final ApiService apiService;
    private final UploadService uploadService;

    public FirebaseAppDistributionUpload(UploadDistributionOptions options, ApiService apiService, UploadService uploadService) {
        this.options = options;
        this.apiService = apiService;
        this.uploadService = uploadService;
    }

    public boolean uploadDistribution() {
        boolean success;
        Optional<String> operationName;
        String appName = this.getAppNameFromAppId(this.options.getAppId());
        Release release = null;
        AabInfo aabInfo = null;
        if (this.options.getBinaryType().equals((Object)BinaryType.AAB) && (aabInfo = this.getAabInfo(appName)).getAabState() != AabState.INTEGRATED && aabInfo.getAabState() != AabState.AAB_STATE_UNAVAILABLE) {
            throw AppDistributionException.forAabState(aabInfo.getAabState());
        }
        this.LOGGER.info(String.format("Uploading the %s.", new Object[]{this.options.getBinaryType()}), new Object[0]);
        try {
            operationName = this.uploadService.uploadDistribution(appName, this.options.getBinary());
            success = operationName.isPresent();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new AppDistributionException(AppDistributionException.Reason.APP_NOT_ONBOARDED_ERROR);
            }
            throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.uploadBinaryError(this.options.getBinaryType()), e);
        }
        catch (IOException e) {
            throw AppDistributionException.fromIoException(AppDistributionException.Reason.uploadBinaryError(this.options.getBinaryType()), e);
        }
        if (success) {
            ReleaseLookup releaseLookup = new ReleaseLookup();
            UploadStatusResponse releaseUploadResponse = releaseLookup.pollForRelease(this.apiService, operationName.get(), this.options.getBinaryType());
            if (releaseUploadResponse.isDone() && releaseUploadResponse.getResponse() != null) {
                release = releaseUploadResponse.getResponse().getRelease();
            } else if (releaseUploadResponse.isDone() && releaseUploadResponse.getError() != null) {
                throw new AppDistributionException(AppDistributionException.Reason.processingBinaryError(this.options.getBinaryType()), releaseUploadResponse.getError().getMessage());
            }
        }
        if (success && release != null) {
            if (aabInfo != null) {
                this.maybePrintAabCertificate(appName, aabInfo);
            }
            if (!Strings.isNullOrEmpty((String)this.options.getReleaseNotes())) {
                try {
                    success = this.apiService.createReleaseNotes(release.getName(), this.options.getReleaseNotes());
                }
                catch (HttpResponseException e) {
                    throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.UPLOAD_RELEASE_NOTES_ERROR, e);
                }
                catch (IOException e) {
                    throw AppDistributionException.fromIoException(AppDistributionException.Reason.UPLOAD_RELEASE_NOTES_ERROR, e);
                }
            } else {
                this.LOGGER.info("No release notes passed in. Skipping this step.", new Object[0]);
            }
            if (this.shouldTest(this.options.getTestDevices())) {
                ReleaseTest releaseTest;
                try {
                    releaseTest = this.apiService.testRelease(release.getName(), this.options.getTestDevices(), this.options.getTestLoginCredential());
                }
                catch (HttpResponseException e) {
                    throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.STARTING_TEST_FAILED, e);
                }
                catch (IOException e) {
                    throw AppDistributionException.fromIoException(AppDistributionException.Reason.STARTING_TEST_FAILED, e);
                }
                if (!this.options.testNonBlocking()) {
                    TestLookup testLookup = new TestLookup();
                    testLookup.pollForReleaseTest(this.apiService, releaseTest.getName());
                }
            }
            if (this.hasTestersOrGroups(this.options.getTesters(), this.options.getGroups())) {
                try {
                    success = this.apiService.distributeRelease(release.getName(), this.options.getTesters(), this.options.getGroups());
                }
                catch (HttpResponseException e) {
                    throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.UPLOAD_TESTERS_ERROR, e);
                }
                catch (IOException e) {
                    throw AppDistributionException.fromIoException(AppDistributionException.Reason.UPLOAD_TESTERS_ERROR, e);
                }
            } else {
                this.LOGGER.info("No testers or groups passed in. Skipping this step.", new Object[0]);
            }
            this.LOGGER.info(String.format("View this release in the Firebase console: %s", release.getFirebaseConsoleUri()), new Object[0]);
            this.LOGGER.info(String.format("Share this release with testers who have access: %s", release.getTestingUri()), new Object[0]);
            this.LOGGER.info(String.format("Download the release binary (link expires in 1 hour): %s", release.getBinaryDownloadUri()), new Object[0]);
        }
        return success;
    }

    private AabInfo getAabInfo(String appName) {
        AabInfo aabInfo;
        try {
            aabInfo = this.apiService.getAabInfo(appName);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new AppDistributionException(AppDistributionException.Reason.APP_NOT_ONBOARDED_ERROR);
            }
            throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.GET_APP_ERROR, e);
        }
        catch (IOException e) {
            throw AppDistributionException.fromIoException(AppDistributionException.Reason.GET_APP_ERROR, e);
        }
        return aabInfo;
    }

    private void maybePrintAabCertificate(String appName, AabInfo aabInfo) {
        AabInfo updatedAabInfo;
        if (this.options.getBinaryType().equals((Object)BinaryType.AAB) && aabInfo.getAabCertificate() == null && (updatedAabInfo = this.getAabInfo(appName)).getAabCertificate() != null) {
            this.LOGGER.info("After you upload an AAB for the first time, App Distribution generates a new test certificate. All AAB uploads are re-signed with this test certificate. Use the certificate fingerprints below to register your app signing key with API providers, such as Google Sign-In and Google Maps.", new Object[0]);
            this.LOGGER.info(String.format("MD5 certificate fingerprint: %s", updatedAabInfo.getAabCertificate().getCertificateHashMd5()), new Object[0]);
            this.LOGGER.info(String.format("SHA-1 certificate fingerprint: %s", updatedAabInfo.getAabCertificate().getCertificateHashSha1()), new Object[0]);
            this.LOGGER.info(String.format("SHA-256 certificate fingerprint: %s", updatedAabInfo.getAabCertificate().getCertificateHashSha256()), new Object[0]);
        }
    }

    private boolean hasTestersOrGroups(List<String> testers, List<String> groups) {
        return testers != null && !testers.isEmpty() || groups != null && !groups.isEmpty();
    }

    private boolean shouldTest(List<TestDevice> devices) {
        return devices != null && !devices.isEmpty();
    }

    private String getAppNameFromAppId(String appId) {
        String projectNumber = appId.split(":")[1];
        return String.format("projects/%s/apps/%s", projectNumber, appId);
    }
}

