/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;

public class OptionsUtils {
    private OptionsUtils() {
    }

    public static List<String> extractListFromCommaSeparatedString(String str) {
        return str == null ? Lists.newArrayList() : Splitter.on((Pattern)Pattern.compile("[,\n]")).omitEmptyStrings().trimResults().splitToList((CharSequence)str);
    }

    public static List<String> extractListFromSemicolonSeparatedString(String str) {
        return str == null ? Lists.newArrayList() : Splitter.on((Pattern)Pattern.compile("[;\n]")).omitEmptyStrings().trimResults().splitToList((CharSequence)str);
    }

    public static String getValueFromValueOrPath(String value, String path) {
        if (Strings.isNullOrEmpty((String)value) && !Strings.isNullOrEmpty((String)path)) {
            try {
                return Files.asCharSource((File)new File(path), (Charset)Charsets.UTF_8).read();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Failed to read file \"%s\"", path), e);
            }
        }
        return value;
    }

    public static File ensureFile(String path, AppDistributionException.Reason missingFileReason) {
        File file = new File(path);
        if (!file.exists()) {
            throw new AppDistributionException(missingFileReason);
        }
        return file;
    }
}

