/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.firebase.appdistribution.gradle.ApiService;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.BinaryType;
import com.google.firebase.appdistribution.gradle.ThreadSleeper;
import com.google.firebase.appdistribution.gradle.models.uploadstatus.UploadStatusResponse;

public class ReleaseLookup {
    private static final long POLLING_INTERVAL = 5000L;
    private static final int MAX_POLLING_RETRIES = 60;
    private final ThreadSleeper threadSleeper;
    private final int maxPollingRetries;

    public ReleaseLookup() {
        this(new ThreadSleeper(), 60);
    }

    ReleaseLookup(ThreadSleeper threadSleeper, int maxPollingRetries) {
        this.threadSleeper = threadSleeper;
        this.maxPollingRetries = maxPollingRetries;
    }

    public UploadStatusResponse pollForRelease(ApiService apiService, String operationName, BinaryType binaryType) throws AppDistributionException {
        for (int numRetries = 0; numRetries < this.maxPollingRetries; ++numRetries) {
            UploadStatusResponse response = apiService.getUploadStatus(operationName, binaryType);
            if (!response.isDone()) {
                try {
                    this.threadSleeper.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("App Distribution ran into an error while looking up the release", ie);
                }
            }
            return response;
        }
        throw new AppDistributionException(AppDistributionException.Reason.GET_RELEASE_TIMEOUT, String.format("It took longer than expected to process your %s, please try again", new Object[]{binaryType}));
    }
}

