/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.AppDistributionPlugin;
import com.google.firebase.appdistribution.gradle.FirebaseAppDistribution;
import com.google.firebase.appdistribution.gradle.GradleLogger;
import com.google.firebase.appdistribution.gradle.TesterManagementOptions;
import com.google.firebase.appdistribution.gradle.TesterManagementTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class RemoveTestersTask
extends TesterManagementTask {
    @TaskAction
    public void removeTesters() {
        try {
            TesterManagementOptions options = this.getOptions();
            FirebaseAppDistribution.removeTesters(options, new GradleLogger(this.getProject().getLogger()), AppDistributionPlugin.getClientProperties());
        }
        catch (AppDistributionException e) {
            this.processException(e);
        }
    }

    private void processException(AppDistributionException e) {
        switch (e.getReason()) {
            case MISSING_PROJECT_NUMBER: {
                throw new GradleException("Could not find your project number. Please verify that you set the command line flag `projectNumber` and try again.");
            }
            case MISSING_TESTER_EMAILS: {
                throw new GradleException("Could not find tester emails to remove. Please verify that you set either the command line flag `emails` or `file` with valid emails, then try again.");
            }
            case MISSING_CREDENTIALS: {
                throw new GradleException("Could not find credentials. To authenticate, you have a few options: \n1. Set the `serviceCredentialsFile` command line flag\n2. Set a refresh token with the FIREBASE_TOKEN environment variable\n3. Log in with the Firebase CLI\n4. Set service credentials with the GOOGLE_APPLICATION_CREDENTIALS environment variable");
            }
        }
        throw new GradleException(e.getMessage(), (Throwable)e);
    }
}

