/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.firebase.appdistribution.gradle.CliRuntime;
import java.io.IOException;

public class RequestBuilder {
    public static final String X_CLIENT_VERSION = "X-Client-Version";
    private final CliRuntime runtimeProperties = CliRuntime.getInstance();
    private final HttpRequest request;

    RequestBuilder(HttpRequest request) {
        this.request = request;
    }

    public RequestBuilder setContent(HttpContent content) {
        this.request.setContent(content);
        return this;
    }

    public RequestBuilder setHeader(String headerName, String value) {
        this.request.getHeaders().set(headerName, (Object)value);
        return this;
    }

    public HttpResponse execute() throws IOException {
        this.addHeaders(this.request.getHeaders());
        this.request.setSuppressUserAgentSuffix(true);
        return this.request.execute();
    }

    private void addHeaders(HttpHeaders headers) {
        String clientVersion = String.format("%s/%s", "gradle", this.runtimeProperties.getClientVersion());
        headers.setUserAgent(String.format("Firebase App Distro Client/%s", this.runtimeProperties.getClientVersion()));
        headers.set(X_CLIENT_VERSION, (Object)clientVersion);
    }
}

