/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.common.collect.ImmutableList;
import com.google.firebase.appdistribution.gradle.AppDistributionEnvironment;
import com.google.firebase.appdistribution.gradle.AppDistributionEnvironmentImpl;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.CredentialsRetriever;
import com.google.firebase.appdistribution.gradle.OptionsUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;

public class TesterManagementOptions {
    private long projectNumber;
    private ImmutableList<String> emails;
    private Credential credentials;

    public long getProjectNumber() {
        return this.projectNumber;
    }

    public ImmutableList<String> getEmails() {
        return this.emails;
    }

    public Credential getCredentials() {
        return this.credentials;
    }

    public static Builder newBuilder() {
        try {
            return new Builder();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot create secure transport");
        }
    }

    public static Builder newBuilder(CredentialsRetriever credentialsRetriever) {
        try {
            return new Builder(credentialsRetriever);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot create secure transport");
        }
    }

    public static Builder newBuilder(HttpTransport transport) {
        return new Builder(transport);
    }

    public static Builder newBuilder(AppDistributionEnvironment appDistributionEnvironment) {
        try {
            return new Builder(appDistributionEnvironment);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot create secure transport");
        }
    }

    public static class Builder {
        private final CredentialsRetriever credentialsRetriever;
        private long projectNumber;
        private String emailsCommaSeparatedList;
        private String emailsFile;
        private String serviceCredentialsFile;

        Builder() throws GeneralSecurityException, IOException {
            this((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), new AppDistributionEnvironmentImpl());
        }

        Builder(CredentialsRetriever credentialsRetriever) throws GeneralSecurityException, IOException {
            this.credentialsRetriever = credentialsRetriever;
        }

        Builder(HttpTransport transport) {
            this(transport, new AppDistributionEnvironmentImpl());
        }

        Builder(AppDistributionEnvironment appDistributionEnvironment) throws GeneralSecurityException, IOException {
            this((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), appDistributionEnvironment);
        }

        Builder(HttpTransport transport, AppDistributionEnvironment appDistributionEnvironment) {
            this.credentialsRetriever = new CredentialsRetriever(transport, appDistributionEnvironment);
        }

        public TesterManagementOptions validateAndBuild() {
            TesterManagementOptions options = new TesterManagementOptions();
            if (this.projectNumber <= 0L) {
                throw new AppDistributionException(AppDistributionException.Reason.MISSING_PROJECT_NUMBER);
            }
            options.projectNumber = this.projectNumber;
            String emailsValue = OptionsUtils.getValueFromValueOrPath(this.emailsCommaSeparatedList, this.emailsFile);
            List<String> emails = OptionsUtils.extractListFromCommaSeparatedString(emailsValue);
            if (emails.isEmpty()) {
                throw new AppDistributionException(AppDistributionException.Reason.MISSING_TESTER_EMAILS);
            }
            options.emails = ImmutableList.copyOf(emails);
            Credential credentials = this.credentialsRetriever.getAuthCredential(Optional.ofNullable(this.serviceCredentialsFile));
            if (credentials == null) {
                throw new AppDistributionException(AppDistributionException.Reason.MISSING_CREDENTIALS);
            }
            options.credentials = credentials;
            return options;
        }

        public Builder setProjectNumber(long projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setEmailsCommaSeparatedList(String emailsCommaSeparatedList) {
            this.emailsCommaSeparatedList = emailsCommaSeparatedList;
            return this;
        }

        public Builder setEmailsFile(String emailsFile) {
            this.emailsFile = emailsFile;
            return this;
        }

        public Builder setServiceCredentialsFile(String serviceCredentialsFile) {
            this.serviceCredentialsFile = serviceCredentialsFile;
            return this;
        }
    }
}

