/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.firebase.appdistribution.gradle.TesterManagementOptions;
import java.util.Optional;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.options.Option;

public abstract class TesterManagementTask
extends DefaultTask {
    private long projectNumber;
    private Optional<String> emails = Optional.empty();
    private Optional<String> file = Optional.empty();
    private Optional<String> serviceCredentialsFile = Optional.empty();

    @Option(option="projectNumber", description="Firebase project number")
    public void setProjectNumber(String projectNumber) {
        try {
            this.projectNumber = Long.parseLong(projectNumber);
        }
        catch (NumberFormatException e) {
            throw new GradleException(String.format("Invalid project number %s", projectNumber));
        }
    }

    @Input
    public long getProjectNumber() {
        return this.projectNumber;
    }

    @Option(option="emails", description="Comma separated list of tester emails")
    public void setEmails(String emails) {
        this.emails = Optional.of(emails);
    }

    @Input
    public Optional<String> getEmails() {
        return this.emails;
    }

    @Option(option="file", description="Path to a file containing a comma separated list of tester emails")
    public void setFile(String file) {
        this.file = Optional.of(file);
    }

    @Input
    public Optional<String> getFile() {
        return this.file;
    }

    @Option(option="serviceCredentialsFile", description="Path to your service account private key JSON file. Required only if you use service account authentication.")
    public void setServiceCredentialsFile(String serviceCredentialsFile) {
        this.serviceCredentialsFile = Optional.of(serviceCredentialsFile);
    }

    @Input
    public Optional<String> getServiceCredentialsFile() {
        return this.serviceCredentialsFile;
    }

    @Internal
    public TesterManagementOptions getOptions() {
        TesterManagementOptions.Builder optionsBuilder = TesterManagementOptions.newBuilder();
        optionsBuilder.setProjectNumber(this.getProjectNumber());
        if (this.getEmails().isPresent()) {
            optionsBuilder.setEmailsCommaSeparatedList(this.getEmails().get());
        }
        if (this.getFile().isPresent()) {
            optionsBuilder.setEmailsFile(this.getFile().get());
        }
        if (this.getServiceCredentialsFile().isPresent()) {
            optionsBuilder.setServiceCredentialsFile(this.getServiceCredentialsFile().get());
        }
        return optionsBuilder.validateAndBuild();
    }
}

