/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.firebase.appdistribution.gradle.AppDistributionEnvironment;
import com.google.firebase.appdistribution.gradle.AppDistributionEnvironmentImpl;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.BinaryType;
import com.google.firebase.appdistribution.gradle.CredentialsRetriever;
import com.google.firebase.appdistribution.gradle.OptionsUtils;
import com.google.firebase.appdistribution.gradle.models.LoginCredential;
import com.google.firebase.appdistribution.gradle.models.LoginCredentialFieldHints;
import com.google.firebase.appdistribution.gradle.models.TestDevice;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UploadDistributionOptions {
    private File binary;
    private String appId;
    private String releaseNotes;
    private List<String> testers;
    private List<String> groups;
    private boolean debug;
    private Credential credentials;
    private List<TestDevice> testDevices;
    private LoginCredential testLoginCredential;
    private boolean testNonBlocking;

    private UploadDistributionOptions() {
    }

    public File getBinary() {
        return this.binary;
    }

    public BinaryType getBinaryType() {
        return BinaryType.fromPath(this.binary.getName());
    }

    public String getAppId() {
        return this.appId;
    }

    public Credential getCredentials() {
        return this.credentials;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public List<String> getTesters() {
        return this.testers;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<TestDevice> getTestDevices() {
        return this.testDevices;
    }

    public LoginCredential getTestLoginCredential() {
        return this.testLoginCredential;
    }

    public boolean testNonBlocking() {
        return this.testNonBlocking;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public static Builder newBuilder() {
        try {
            return new Builder();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot create secure transport", e);
        }
    }

    public static Builder newBuilder(HttpTransport transport) {
        return new Builder(transport);
    }

    public static Builder newBuilder(CredentialsRetriever credentialsRetriever) {
        try {
            return new Builder(credentialsRetriever);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot create secure transport", e);
        }
    }

    public static Builder newBuilder(AppDistributionEnvironment appDistributionEnvironment) {
        try {
            return new Builder(appDistributionEnvironment);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot create secure transport", e);
        }
    }

    private static Boolean isPresenceMismatched(String value1, String value2) {
        return value1 == null ^ value2 == null;
    }

    private static TestDevice parseTestDevice(String s) {
        Map attributes = Splitter.on((char)',').omitEmptyStrings().trimResults().withKeyValueSeparator('=').split((CharSequence)s);
        return new TestDevice().setModel((String)attributes.get("model")).setVersion((String)attributes.get("version")).setOrientation((String)attributes.get("orientation")).setLocale((String)attributes.get("locale"));
    }

    public static class Builder {
        private static final Pattern APP_ID_PATTERN = Pattern.compile("(?<version>\\d+):(?<projectNumber>\\d+):(?<platform>ios|android|web):(\\p{XDigit}+)");
        private final CredentialsRetriever credentialsRetriever;
        private File binary;
        private String appId;
        private String serviceCredentialsFile;
        private String releaseNotes;
        private List<String> testers;
        private List<String> groups;
        private List<TestDevice> testDevices;
        private LoginCredential testLoginCredential;
        private boolean testNonBlocking = false;
        private boolean debug = false;

        Builder() throws GeneralSecurityException, IOException {
            this((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), new AppDistributionEnvironmentImpl());
        }

        Builder(CredentialsRetriever credentialsRetriever) throws GeneralSecurityException, IOException {
            this.credentialsRetriever = credentialsRetriever;
        }

        Builder(HttpTransport transport) {
            this(transport, new AppDistributionEnvironmentImpl());
        }

        Builder(AppDistributionEnvironment appDistributionEnvironment) throws GeneralSecurityException, IOException {
            this((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), appDistributionEnvironment);
        }

        Builder(HttpTransport transport, AppDistributionEnvironment appDistributionEnvironment) {
            this.credentialsRetriever = new CredentialsRetriever(transport, appDistributionEnvironment);
        }

        public UploadDistributionOptions build() {
            UploadDistributionOptions options = new UploadDistributionOptions();
            options.binary = this.binary;
            options.appId = this.appId;
            options.releaseNotes = this.releaseNotes;
            options.testers = this.testers;
            options.groups = this.groups;
            options.debug = this.debug;
            options.credentials = this.credentialsRetriever.getAuthCredential(Optional.ofNullable(this.serviceCredentialsFile));
            options.testDevices = this.testDevices;
            this.validateTestLoginCredential();
            options.testLoginCredential = this.testLoginCredential;
            options.testNonBlocking = this.testNonBlocking;
            return options;
        }

        public Builder setDistributionFile(String distributionFile) {
            this.binary = OptionsUtils.ensureFile(distributionFile, AppDistributionException.Reason.binaryNotFoundError(BinaryType.fromPath(distributionFile)));
            return this;
        }

        public Builder setServiceCredentialsFile(String serviceCredentialsFile) {
            this.serviceCredentialsFile = serviceCredentialsFile;
            return this;
        }

        public Builder setReleaseNotes(String releaseNotes, String releaseNotesFile) {
            this.releaseNotes = OptionsUtils.getValueFromValueOrPath(releaseNotes, releaseNotesFile);
            return this;
        }

        public Builder setTesters(String testers, String testersFile) {
            String testersValue = OptionsUtils.getValueFromValueOrPath(testers, testersFile);
            this.testers = OptionsUtils.extractListFromCommaSeparatedString(testersValue);
            return this;
        }

        public Builder setGroups(String groups, String groupsFile) {
            String groupsValue = OptionsUtils.getValueFromValueOrPath(groups, groupsFile);
            this.groups = OptionsUtils.extractListFromCommaSeparatedString(groupsValue);
            return this;
        }

        public Builder setAppId(String appId) {
            if (Strings.isNullOrEmpty((String)appId)) {
                throw new AppDistributionException(AppDistributionException.Reason.MISSING_APP_ID);
            }
            if (!APP_ID_PATTERN.matcher(appId).matches()) {
                throw new AppDistributionException(AppDistributionException.Reason.INVALID_APP_ID);
            }
            this.appId = appId;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder setTestDevices(String testDevices, String testDevicesFile) {
            String value = OptionsUtils.getValueFromValueOrPath(testDevices, testDevicesFile);
            this.testDevices = OptionsUtils.extractListFromSemicolonSeparatedString(value).stream().map(x$0 -> UploadDistributionOptions.parseTestDevice(x$0)).collect(Collectors.toList());
            return this;
        }

        public Builder setTestLoginUsername(String username) {
            if (this.testLoginCredential == null) {
                this.testLoginCredential = new LoginCredential();
            }
            this.testLoginCredential.setUsername(username);
            return this;
        }

        public Builder setTestLoginPassword(String password, String passwordFile) {
            String passwordValue = OptionsUtils.getValueFromValueOrPath(password, passwordFile);
            if (passwordValue != null) {
                if (this.testLoginCredential == null) {
                    this.testLoginCredential = new LoginCredential();
                }
                this.testLoginCredential.setPassword(passwordValue.trim());
            }
            return this;
        }

        public Builder setTestLoginResourceNames(String usernameResource, String passwordResource) {
            if (usernameResource != null || passwordResource != null) {
                if (this.testLoginCredential == null) {
                    this.testLoginCredential = new LoginCredential();
                }
                this.testLoginCredential.setFieldHints(new LoginCredentialFieldHints().setUsernameResourceName(usernameResource).setPasswordResourceName(passwordResource));
            }
            return this;
        }

        public void validateTestLoginCredential() {
            if (this.testLoginCredential != null) {
                String passwordResource;
                String username = this.testLoginCredential.getUsername();
                String password = this.testLoginCredential.getPassword();
                String usernameResource = this.testLoginCredential.getFieldHints() != null ? this.testLoginCredential.getFieldHints().getUsernameResourceName() : null;
                String string = passwordResource = this.testLoginCredential.getFieldHints() != null ? this.testLoginCredential.getFieldHints().getPasswordResourceName() : null;
                if (UploadDistributionOptions.isPresenceMismatched(username, password).booleanValue()) {
                    throw new AppDistributionException(AppDistributionException.Reason.TEST_LOGIN_CREDENTIAL_MISMATCH);
                }
                if (UploadDistributionOptions.isPresenceMismatched(usernameResource, passwordResource).booleanValue()) {
                    throw new AppDistributionException(AppDistributionException.Reason.TEST_LOGIN_CREDENTIAL_RESOURCE_MISMATCH);
                }
                if (usernameResource != null && passwordResource != null && username == null && password == null) {
                    throw new AppDistributionException(AppDistributionException.Reason.TEST_LOGIN_CREDENTIAL_MISSING);
                }
            }
        }

        public Builder setTestNonBlocking(boolean nonBlocking) {
            this.testNonBlocking = nonBlocking;
            return this;
        }
    }
}

