/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.google.common.collect.ImmutableList;
import com.google.firebase.appdistribution.gradle.AppDistributionException;
import com.google.firebase.appdistribution.gradle.AppDistributionLogger;
import com.google.firebase.appdistribution.gradle.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.gradle.AppDistributionPlugin;
import com.google.firebase.appdistribution.gradle.BinaryType;
import com.google.firebase.appdistribution.gradle.FirebaseAppDistribution;
import com.google.firebase.appdistribution.gradle.GradleLogger;
import com.google.firebase.appdistribution.gradle.UploadDistributionOptions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UploadDistributionTask
extends DefaultTask {
    private static AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();
    private static final String ARTIFACT_TYPE_AAB = "AAB";
    private static final String SUPPORT_EMAIL = "firebase-support@google.com";
    @Option(option="groups", description="A comma-separated list of group aliases you want to distribute builds to.")
    @Input
    @Optional
    final Property<String> groups = this.stringProperty();
    @Option(option="groupsFile", description="Absolute path to a file containing a comma-separated list of group aliases you want to distribute builds to.")
    @Input
    @Optional
    final Property<String> groupsFile = this.stringProperty();
    @Option(option="releaseNotes", description="Release notes for this build.")
    @Input
    @Optional
    final Property<String> releaseNotes = this.stringProperty();
    @Option(option="releaseNotesFile", description="Absolute path to a file containing release notes for this build.")
    @Input
    @Optional
    final Property<String> releaseNotesFile = this.stringProperty();
    @Option(option="serviceCredentialsFile", description="The path to your service account private key JSON file.")
    @Input
    @Optional
    final Property<String> serviceCredentialsFile = this.stringProperty();
    @Option(option="testers", description="A comma-separated list of email addresses of the the testers you want to distribute builds to.")
    @Input
    @Optional
    final Property<String> testers = this.stringProperty();
    @Option(option="testersFile", description="Absolute path to a file containing a comma-separated list of email addresses of the testers you want to distribute builds to.")
    @Input
    @Optional
    final Property<String> testersFile = this.stringProperty();
    @Option(option="appId", description="Your app's Firebase App ID.")
    @Input
    @Optional
    final Property<String> appId = this.stringProperty();
    @Option(option="artifactPath", description="Absolute path to the APK or AAB file you want to upload.")
    @Input
    @Optional
    final Property<String> artifactPath = this.stringProperty();
    @Option(option="artifactType", description="Specifies your app's file type. Can be set to \"AAB\" or \"APK\". If not set, assumed to be APK.")
    @Input
    @Optional
    final Property<String> artifactType = this.stringProperty();
    @Option(option="testDevices", description="A semicolon-separated list of devices to run automated tests on, in the format 'model=<model-id>,version=<os-version-id>,locale=<locale>,orientation=<orientation>;model=<model-id>,...'. Run 'gcloud firebase test android|ios models list' to see available devices. Note: This feature is in beta.")
    @Input
    @Optional
    final Property<String> testDevices = this.stringProperty();
    @Option(option="testerDevicesFile", description="Absolute path to a file containing a semicolon-separated list of devices to run automated tests on, in the format 'model=<model-id>,version=<os-version-id>,locale=<locale>,orientation=<orientation>;model=<model-id>,...'. Run 'gcloud firebase test android|ios models list' to see available devices. Note: This feature is in beta.")
    @Input
    @Optional
    final Property<String> testerDevicesFile = this.stringProperty();
    @Option(option="testUsername", description="Username for automatic login")
    @Input
    @Optional
    final Property<String> testUsername = this.stringProperty();
    @Option(option="testPassword", description="Password for automatic login. If using a real password consider using testPasswordFile")
    @Input
    @Optional
    final Property<String> testPassword = this.stringProperty();
    @Option(option="testPasswordFile", description="Path to file containing password for automatic login")
    @Input
    @Optional
    final Property<String> testPasswordFile = this.stringProperty();
    @Option(option="testUsernameResource", description="Resource name for the username for automatic login")
    @Input
    @Optional
    final Property<String> testUsernameResource = this.stringProperty();
    @Option(option="testPasswordResource", description="Resource name for the password for automatic login")
    @Input
    @Optional
    final Property<String> testPasswordResource = this.stringProperty();
    @Option(option="testNonBlocking", description="Run tests asynchronously. Visit the Firebase console for the automatic test results.")
    @Input
    @Optional
    final Property<Boolean> testNonBlocking = this.booleanProperty();
    RegularFileProperty inferredAab = this.fileProperty();
    DirectoryProperty inferredApkDirectory = this.directoryProperty();
    @Internal
    private final DirectoryProperty googleServicesDirectory = this.directoryProperty();

    public UploadDistributionTask() {
        try {
            Method doNotTrackState = ((Object)((Object)this)).getClass().getMethod("doNotTrackState", new Class[0]);
            doNotTrackState.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    @TaskAction
    void uploadDistribution() {
        try {
            Class.forName("com.android.build.api.variant.ApplicationAndroidComponentsExtension");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOGGER.warn("Warning: The App Distribution Gradle plugin has deprecated support for versions of Android Gradle Plugin lower than 7.0.0. Support for these lower versions will be completely removed as early as April 2024.", new Object[0]);
        }
        String path = this.determineArtifactPath();
        System.out.printf("Uploading %s to Firebase App Distribution...%n", new Object[]{BinaryType.fromPath(path)});
        UploadDistributionOptions.Builder optionsBuilder = UploadDistributionOptions.newBuilder();
        optionsBuilder.setDistributionFile(path).setAppId(this.determineAppId()).setReleaseNotes((String)this.releaseNotes.getOrNull(), (String)this.releaseNotesFile.getOrNull()).setTesters((String)this.testers.getOrNull(), (String)this.testersFile.getOrNull()).setGroups((String)this.groups.getOrNull(), (String)this.groupsFile.getOrNull()).setTestDevices((String)this.testDevices.getOrNull(), (String)this.testerDevicesFile.getOrNull()).setTestLoginUsername((String)this.testUsername.getOrNull()).setTestLoginPassword((String)this.testPassword.getOrNull(), (String)this.testPasswordFile.getOrNull()).setTestLoginResourceNames((String)this.testUsernameResource.getOrNull(), (String)this.testPasswordResource.getOrNull()).setTestNonBlocking((Boolean)this.testNonBlocking.getOrElse((Object)false));
        if (this.serviceCredentialsFile.isPresent()) {
            optionsBuilder.setServiceCredentialsFile((String)this.serviceCredentialsFile.get());
            System.out.printf("Using service credentials file specified by the serviceCredentialsFile property in your app's build.gradle file: %s%n", this.serviceCredentialsFile.get());
        }
        this.uploadDistribution(optionsBuilder.build());
    }

    public Property<String> getGroups() {
        return this.groups;
    }

    public Property<String> getGroupsFile() {
        return this.groupsFile;
    }

    public Property<String> getAppId() {
        return this.appId;
    }

    public Property<String> getReleaseNotes() {
        return this.releaseNotes;
    }

    public Property<String> getReleaseNotesFile() {
        return this.releaseNotesFile;
    }

    public Property<String> getServiceCredentialsFile() {
        return this.serviceCredentialsFile;
    }

    public Property<String> getTesters() {
        return this.testers;
    }

    public Property<String> getTestersFile() {
        return this.testersFile;
    }

    public Property<String> getArtifactPath() {
        return this.artifactPath;
    }

    public Property<String> getArtifactType() {
        return this.artifactType;
    }

    public Property<String> getTestDevices() {
        return this.testDevices;
    }

    public Property<String> getTesterDevicesFile() {
        return this.testerDevicesFile;
    }

    public Property<String> getTestUsername() {
        return this.testUsername;
    }

    public Property<String> getTestPassword() {
        return this.testPassword;
    }

    public Property<String> getTestPasswordFile() {
        return this.testPasswordFile;
    }

    public Property<String> getTestUsernameResource() {
        return this.testUsernameResource;
    }

    public Property<String> getTestPasswordResource() {
        return this.testPasswordResource;
    }

    public Property<Boolean> getTestNonBlocking() {
        return this.testNonBlocking;
    }

    public Property<Directory> getGoogleServicesDirectory() {
        return this.googleServicesDirectory;
    }

    private Property<Boolean> booleanProperty() {
        return this.getProject().getObjects().property(Boolean.class);
    }

    private Property<String> stringProperty() {
        return this.getProject().getObjects().property(String.class);
    }

    private RegularFileProperty fileProperty() {
        return this.getProject().getObjects().fileProperty();
    }

    private DirectoryProperty directoryProperty() {
        return this.getProject().getObjects().directoryProperty();
    }

    private void uploadDistribution(UploadDistributionOptions uploadDistributionOptions) {
        GradleLogger logger = new GradleLogger(this.getLogger());
        try {
            FirebaseAppDistribution.uploadDistribution(uploadDistributionOptions, logger, AppDistributionPlugin.getClientProperties());
            System.out.println("App Distribution upload finished successfully!");
        }
        catch (AppDistributionException e) {
            switch (e.getReason()) {
                case APP_NOT_ONBOARDED_ERROR: {
                    throw new GradleException("App Distribution could not find your app " + uploadDistributionOptions.getAppId() + ".\nMake sure to onboard your app by pressing the \"Get started\" button on the App Distribution page in the Firebase console:\n\n\thttps://console.firebase.google.com/project/_/appdistribution");
                }
                case MISSING_CREDENTIALS: {
                    throw new GradleException("Could not find credentials. To authenticate, you have a few options: \n1. Set the `serviceCredentialsFile` property in your gradle plugin\n2. Set a refresh token with the FIREBASE_TOKEN environment variable\n3. Log in with the Firebase CLI\n4. Set service credentials with the GOOGLE_APPLICATION_CREDENTIALS environment variable");
                }
                case MISSING_APP_ID: {
                    throw new GradleException("Could not find your app id. Please verify that you set the property `appId` in your app's build.gradle file and try again.");
                }
            }
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
    }

    private String determineAppId() {
        if (this.appId.isPresent()) {
            return (String)this.appId.get();
        }
        if (!this.googleServicesDirectory.isPresent()) {
            return null;
        }
        File googleServicesXml = new File((File)this.googleServicesDirectory.getAsFile().get(), "values/values.xml");
        if (!googleServicesXml.exists()) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(googleServicesXml);
            NodeList stringNodes = doc.getElementsByTagName("string");
            for (int i = 0; i < stringNodes.getLength(); ++i) {
                Element stringElement;
                String name;
                Node stringNode = stringNodes.item(i);
                if (stringNode.getNodeType() != 1 || !(name = (stringElement = (Element)stringNode).getAttribute("name")).equals("google_app_id")) continue;
                return stringNode.getTextContent();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return null;
    }

    private String determineArtifactPath() {
        String path;
        if (this.artifactPath.isPresent()) {
            System.out.printf("Using %s path specified by the artifactPath parameter in your app's build.gradle: %s.%n", new Object[]{BinaryType.fromPath((String)this.artifactPath.get()), this.artifactPath.get()});
            return (String)this.artifactPath.get();
        }
        if (this.artifactType.isPresent() && ((String)this.artifactType.get()).equals(ARTIFACT_TYPE_AAB)) {
            if (!this.inferredAab.isPresent()) {
                throw new GradleException("Could not find an AAB file for this variant for App Distribution");
            }
            path = ((RegularFile)this.inferredAab.get()).getAsFile().getPath();
        } else {
            ImmutableList apks = (ImmutableList)this.inferredApkDirectory.getAsFileTree().getFiles().stream().filter(file -> file.getPath().endsWith(".apk")).collect(ImmutableList.toImmutableList());
            switch (apks.size()) {
                case 0: {
                    throw new GradleException("Could not find an APK file for this variant for App Distribution");
                }
                case 1: {
                    path = ((File)apks.get(0)).getPath();
                    break;
                }
                default: {
                    throw new GradleException(String.format("App Distribution found more than 1 output file for this variant. Please contact %s for help using APK splits with App Distribution.", SUPPORT_EMAIL));
                }
            }
        }
        System.out.printf("Using %s path in the outputs directory: %s.%n", new Object[]{BinaryType.fromPath(path), path});
        return path;
    }
}

