/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.gradle;

import com.android.build.gradle.api.ApplicationVariant;
import com.google.firebase.appdistribution.gradle.AppDistributionExtension;
import com.google.firebase.appdistribution.gradle.ArtifactResolver;
import com.google.firebase.appdistribution.gradle.UploadDistributionTask;
import com.google.firebase.appdistribution.gradle.UploadDistributionTaskConfigurator;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/google/firebase/appdistribution/gradle/UploadDistributionTaskConfigurator;", "", "()V", "assembleTaskName", "", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "bundleTaskName", "capitalizedVariantName", "configure", "", "task", "Lcom/google/firebase/appdistribution/gradle/UploadDistributionTask;", "extension", "Lcom/google/firebase/appdistribution/gradle/AppDistributionExtension;", "configureGoogleServicesPluginPath", "nullOrAbsolutePath", "stringPath", "project", "Lorg/gradle/api/Project;", "appdistribution-gradle"})
@SourceDebugExtension(value={"SMAP\nUploadDistributionTaskConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadDistributionTaskConfigurator.kt\ncom/google/firebase/appdistribution/gradle/UploadDistributionTaskConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class UploadDistributionTaskConfigurator {
    @NotNull
    public static final UploadDistributionTaskConfigurator INSTANCE = new UploadDistributionTaskConfigurator();

    private UploadDistributionTaskConfigurator() {
    }

    @JvmStatic
    public static final void configure(@NotNull UploadDistributionTask task, @NotNull ApplicationVariant variant, @NotNull AppDistributionExtension extension) {
        UploadDistributionTask uploadDistributionTask;
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        UploadDistributionTask $this$configure_u24lambda_u240 = uploadDistributionTask = task;
        boolean bl = false;
        Object[] objectArray = new String[]{INSTANCE.bundleTaskName(variant), INSTANCE.assembleTaskName(variant)};
        $this$configure_u24lambda_u240.setMustRunAfter(CollectionsKt.listOf((Object[])objectArray));
        $this$configure_u24lambda_u240.appId.set((Object)extension.appId);
        Property<String> property = $this$configure_u24lambda_u240.artifactPath;
        String string = extension.artifactPath;
        Project project = $this$configure_u24lambda_u240.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        property.set((Object)INSTANCE.nullOrAbsolutePath(string, project));
        $this$configure_u24lambda_u240.artifactType.set((Object)extension.artifactType);
        $this$configure_u24lambda_u240.groups.set((Object)extension.groups);
        Property<String> property2 = $this$configure_u24lambda_u240.groupsFile;
        String string2 = extension.groupsFile;
        Project project2 = $this$configure_u24lambda_u240.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        property2.set((Object)INSTANCE.nullOrAbsolutePath(string2, project2));
        $this$configure_u24lambda_u240.releaseNotes.set((Object)extension.releaseNotes);
        Property<String> property3 = $this$configure_u24lambda_u240.releaseNotesFile;
        String string3 = extension.releaseNotesFile;
        Project project3 = $this$configure_u24lambda_u240.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        property3.set((Object)INSTANCE.nullOrAbsolutePath(string3, project3));
        $this$configure_u24lambda_u240.testers.set((Object)extension.testers);
        Property<String> property4 = $this$configure_u24lambda_u240.testersFile;
        String string4 = extension.testersFile;
        Project project4 = $this$configure_u24lambda_u240.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        property4.set((Object)INSTANCE.nullOrAbsolutePath(string4, project4));
        $this$configure_u24lambda_u240.testDevices.set((Object)extension.testDevices);
        Property<String> property5 = $this$configure_u24lambda_u240.testerDevicesFile;
        String string5 = extension.testDevicesFile;
        Project project5 = $this$configure_u24lambda_u240.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        property5.set((Object)INSTANCE.nullOrAbsolutePath(string5, project5));
        $this$configure_u24lambda_u240.testUsername.set((Object)extension.testUsername);
        $this$configure_u24lambda_u240.testPassword.set((Object)extension.testPassword);
        $this$configure_u24lambda_u240.testPasswordFile.set((Object)extension.testPasswordFile);
        $this$configure_u24lambda_u240.testUsernameResource.set((Object)extension.testUsernameResource);
        $this$configure_u24lambda_u240.testPasswordResource.set((Object)extension.testPasswordResource);
        $this$configure_u24lambda_u240.testNonBlocking.set((Object)extension.testNonBlocking);
        Property<String> property6 = $this$configure_u24lambda_u240.serviceCredentialsFile;
        String string6 = extension.serviceCredentialsFile;
        Project project6 = $this$configure_u24lambda_u240.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
        property6.set((Object)INSTANCE.nullOrAbsolutePath(string6, project6));
        ArtifactResolver.ArtifactResolution resolution = ArtifactResolver.resolve($this$configure_u24lambda_u240.getProject(), variant);
        $this$configure_u24lambda_u240.inferredAab = resolution.aabFile;
        $this$configure_u24lambda_u240.inferredApkDirectory = resolution.apkDir;
        INSTANCE.configureGoogleServicesPluginPath($this$configure_u24lambda_u240, variant);
    }

    private final void configureGoogleServicesPluginPath(UploadDistributionTask task, ApplicationVariant variant) {
        task.getProject().afterEvaluate(arg_0 -> UploadDistributionTaskConfigurator.configureGoogleServicesPluginPath$lambda$1((Function1)new Function1<Project, Unit>(variant, task){
            final /* synthetic */ ApplicationVariant $variant;
            final /* synthetic */ UploadDistributionTask $task;
            {
                this.$variant = $variant;
                this.$task = $task;
                super(1);
            }

            public final void invoke(Project project) {
                try {
                    boolean bl;
                    DirectoryProperty dirProperty;
                    Provider resourceDirProp2;
                    block6: {
                        String googleServicesTaskName = "process" + UploadDistributionTaskConfigurator.access$capitalizedVariantName(UploadDistributionTaskConfigurator.INSTANCE, this.$variant) + "GoogleServices";
                        TaskProvider googleServicesTask = this.$task.getProject().getTasks().named(googleServicesTaskName);
                        resourceDirProp2 = googleServicesTask.map(arg_0 -> configureGoogleServicesPluginPath.1.invoke$lambda$0(configureGoogleServicesPluginPath.resourceDirProp.1.INSTANCE, arg_0));
                        dirProperty = project.getObjects().directoryProperty();
                        Iterable $this$any$iv = JvmClassMappingKt.getKotlinClass(dirProperty.getClass()).getMembers();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                KCallable it = (KCallable)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"fileProvider")) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.$task.getGoogleServicesDirectory().set((Provider)dirProperty.fileProvider(resourceDirProp2));
                        return;
                    }
                    this.$task.getGoogleServicesDirectory().value((Object)project.getLayout().getProjectDirectory().dir(project.getBuildDir().getAbsolutePath() + "/generated/res/google-services/" + this.$variant.getDirName()));
                }
                catch (UnknownTaskException unknownTaskException) {
                    // empty catch block
                }
            }

            private static final File invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (File)$tmp0.invoke(p0);
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final String capitalizedVariantName(ApplicationVariant variant) {
        String string;
        String string2 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
        String string3 = string2;
        if (((CharSequence)string3).length() > 0) {
            String string4;
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)it)) {
                String string5 = String.valueOf((char)it).toUpperCase(Locale.ROOT);
                string4 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            } else {
                string4 = String.valueOf((char)it);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string6 = string3;
            int n = 1;
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string7).toString();
        } else {
            string = string3;
        }
        return string;
    }

    private final String assembleTaskName(ApplicationVariant variant) {
        return "assemble" + this.capitalizedVariantName(variant);
    }

    private final String bundleTaskName(ApplicationVariant variant) {
        return "bundle" + this.capitalizedVariantName(variant);
    }

    private final String nullOrAbsolutePath(String stringPath, Project project) {
        String string;
        if (stringPath == null) {
            string = null;
        } else {
            String string2;
            try {
                String string3;
                Path path = Paths.get(stringPath, new String[0]);
                if (path.isAbsolute()) {
                    string3 = ((Object)path).toString();
                } else {
                    Path path2 = Paths.get(project.getRootDir().getPath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(project. getRootDir().getPath())");
                    Path rootPath = path2;
                    string3 = ((Object)rootPath.resolve(path)).toString();
                }
                string2 = string3;
            }
            catch (InvalidPathException e) {
                throw new GradleException(stringPath + " is an invalid path", (Throwable)e);
            }
            string = string2;
        }
        return string;
    }

    private static final void configureGoogleServicesPluginPath$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$capitalizedVariantName(UploadDistributionTaskConfigurator $this, ApplicationVariant variant) {
        return $this.capitalizedVariantName(variant);
    }
}

