/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestMapEntrySetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public class BiMapGenerators {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableBiMapEntrySetGenerator
    extends TestMapEntrySetGenerator<String, String> {
        public ImmutableBiMapEntrySetGenerator() {
            super(new SampleElements.Strings(), new SampleElements.Strings());
        }

        @Override
        public Set<Map.Entry<String, String>> createFromEntries(Map.Entry<String, String>[] entries) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                map.put(entry.getKey(), entry.getValue());
            }
            return ImmutableBiMap.copyOf((Map)map).entrySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableBiMapInverseValuesGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (int i = 0; i < elements.length; ++i) {
                map.put(elements[i], i);
            }
            return ImmutableBiMap.copyOf((Map)map).inverse().values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableBiMapInverseKeySetGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (int i = 0; i < elements.length; ++i) {
                map.put(i, elements[i]);
            }
            return ImmutableBiMap.copyOf((Map)map).inverse().keySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableBiMapInverseEntrySetGenerator
    extends TestMapEntrySetGenerator<String, String> {
        public ImmutableBiMapInverseEntrySetGenerator() {
            super(new SampleElements.Strings(), new SampleElements.Strings());
        }

        @Override
        public Set<Map.Entry<String, String>> createFromEntries(Map.Entry<String, String>[] entries) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                map.put(entry.getValue(), entry.getKey());
            }
            return ImmutableBiMap.copyOf((Map)map).inverse().entrySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableBiMapValuesGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (int i = 0; i < elements.length; ++i) {
                map.put(i, elements[i]);
            }
            return ImmutableBiMap.copyOf((Map)map).values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableBiMapKeySetGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (int i = 0; i < elements.length; ++i) {
                map.put(elements[i], i);
            }
            return ImmutableBiMap.copyOf((Map)map).keySet();
        }
    }
}

