/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionContainsAllTester<E>
extends AbstractCollectionTester<E> {
    public void testContainsAll_empty() {
        CollectionContainsAllTester.assertTrue((String)"containsAll(empty) should return true", (boolean)this.collection.containsAll(MinimalCollection.of(new Object[0])));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsAll_subset() {
        CollectionContainsAllTester.assertTrue((String)"containsAll(subset) should return true", (boolean)this.collection.containsAll(MinimalCollection.of(this.samples.e0)));
    }

    public void testContainsAll_sameElements() {
        CollectionContainsAllTester.assertTrue((String)"containsAll(sameElements) should return true", (boolean)this.collection.containsAll(MinimalCollection.of(this.createSamplesArray())));
    }

    public void testContainsAll_self() {
        CollectionContainsAllTester.assertTrue((String)"containsAll(this) should return true", (boolean)this.collection.containsAll(this.collection));
    }

    public void testContainsAll_partialOverlap() {
        CollectionContainsAllTester.assertFalse((String)"containsAll(partialOverlap) should return false", (boolean)this.collection.containsAll(MinimalCollection.of(this.samples.e0, this.samples.e3)));
    }

    public void testContainsAll_disjoint() {
        CollectionContainsAllTester.assertFalse((String)"containsAll(disjoint) should return false", (boolean)this.collection.containsAll(MinimalCollection.of(this.samples.e3)));
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testContainsAll_nullNotAllowed() {
        try {
            CollectionContainsAllTester.assertFalse((boolean)this.collection.containsAll(MinimalCollection.of(new Object[]{null})));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testContainsAll_nullAllowed() {
        CollectionContainsAllTester.assertFalse((boolean)this.collection.containsAll(MinimalCollection.of(new Object[]{null})));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testContainsAll_nullPresent() {
        this.initCollectionWithNullElement();
        CollectionContainsAllTester.assertTrue((boolean)this.collection.containsAll(MinimalCollection.of(new Object[]{null})));
    }

    public void testContainsAll_wrongType() {
        MinimalCollection<WrongType> wrong = MinimalCollection.of(WrongType.VALUE);
        try {
            CollectionContainsAllTester.assertFalse((String)"containsAll(wrongType) should return false or throw", (boolean)this.collection.containsAll(wrong));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

