/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapRemoveEntryTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAbsent() {
        MultimapRemoveEntryTester.assertFalse((boolean)this.multimap().remove(this.k0(), this.v1()));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemovePresent() {
        MultimapRemoveEntryTester.assertTrue((boolean)this.multimap().remove(this.k0(), this.v0()));
        MultimapRemoveEntryTester.assertFalse((boolean)this.multimap().containsEntry(this.k0(), this.v0()));
        this.expectMissing((Map.Entry)this.e0());
        MultimapRemoveEntryTester.assertEquals((int)(this.getNumElements() - 1), (int)this.multimap().size());
        this.assertGet(this.k0(), ImmutableList.of());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    public void testRemoveNullKeyPresent() {
        this.initMultimapWithNullKey();
        MultimapRemoveEntryTester.assertTrue((boolean)this.multimap().remove(null, this.getValueForNullKey()));
        this.expectMissing(Helpers.mapEntry(null, this.getValueForNullKey()));
        this.assertGet(this.getKeyForNullValue(), ImmutableList.of());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUES})
    public void testRemoveNullValuePresent() {
        this.initMultimapWithNullValue();
        MultimapRemoveEntryTester.assertTrue((boolean)this.multimap().remove(this.getKeyForNullValue(), null));
        this.expectMissing(Helpers.mapEntry(this.getKeyForNullValue(), null));
        this.assertGet(this.getKeyForNullValue(), ImmutableList.of());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testRemoveNullKeyAbsent() {
        MultimapRemoveEntryTester.assertFalse((boolean)this.multimap().remove(null, this.v0()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testRemoveNullValueAbsent() {
        MultimapRemoveEntryTester.assertFalse((boolean)this.multimap().remove(this.k0(), null));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testRemoveNullValueForbidden() {
        try {
            this.multimap().remove(this.k0(), null);
            MultimapRemoveEntryTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testRemoveNullKeyForbidden() {
        try {
            this.multimap().remove(null, this.v0());
            MultimapRemoveEntryTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemovePropagatesToGet() {
        List<Map.Entry> entries = Helpers.copyToList(this.multimap().entries());
        for (Map.Entry entry : entries) {
            this.resetContainer();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Collection collection = this.multimap().get(key);
            MultimapRemoveEntryTester.assertNotNull((Object)collection);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().remove(key, value);
            expectedCollection.remove(value);
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapRemoveEntryTester.assertEquals((!expectedCollection.isEmpty() ? 1 : 0) != 0, (boolean)this.multimap().containsKey(key));
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemovePropagatesToAsMap() {
        List<Map.Entry> entries = Helpers.copyToList(this.multimap().entries());
        for (Map.Entry entry : entries) {
            this.resetContainer();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Collection collection = (Collection)this.multimap().asMap().get(key);
            MultimapRemoveEntryTester.assertNotNull((Object)collection);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().remove(key, value);
            expectedCollection.remove(value);
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapRemoveEntryTester.assertEquals((!expectedCollection.isEmpty() ? 1 : 0) != 0, (boolean)this.multimap().containsKey(key));
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemovePropagatesToAsMapEntrySet() {
        List<Map.Entry> entries = Helpers.copyToList(this.multimap().entries());
        for (Map.Entry entry : entries) {
            this.resetContainer();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Iterator asMapItr = this.multimap().asMap().entrySet().iterator();
            Collection collection = null;
            while (asMapItr.hasNext()) {
                Map.Entry asMapEntry = asMapItr.next();
                if (!key.equals(asMapEntry.getKey())) continue;
                collection = (Collection)asMapEntry.getValue();
                break;
            }
            MultimapRemoveEntryTester.assertNotNull(collection);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().remove(key, value);
            expectedCollection.remove(value);
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapRemoveEntryTester.assertEquals((!expectedCollection.isEmpty() ? 1 : 0) != 0, (boolean)this.multimap().containsKey(key));
        }
    }
}

