/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=lv
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "lv" locale.
 */
public class LocalizedNamesImpl_lv extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DZ",
        "AS",
        "US",
        "AD",
        "AI",
        "AO",
        "AQ",
        "AG",
        "AE",
        "AR",
        "AM",
        "AW",
        "UM",
        "VI",
        "AU",
        "AT",
        "TL",
        "AZ",
        "BS",
        "BH",
        "BY",
        "BD",
        "BB",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "CF",
        "CW",
        "TD",
        "CZ",
        "CL",
        "DK",
        "AC",
        "ZA",
        "GS",
        "KR",
        "DG",
        "DM",
        "DO",
        "JE",
        "DJ",
        "EG",
        "EU",
        "EC",
        "GQ",
        "ER",
        "ET",
        "FO",
        "FJ",
        "PH",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "GA",
        "GY",
        "GM",
        "GH",
        "GG",
        "GI",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "GP",
        "GT",
        "GN",
        "GW",
        "HT",
        "HM",
        "HN",
        "HK",
        "HR",
        "EE",
        "IN",
        "IO",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IT",
        "IL",
        "JM",
        "JP",
        "NC",
        "NZ",
        "YE",
        "JO",
        "CV",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "QA",
        "KZ",
        "KE",
        "CY",
        "KG",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CI",
        "RU",
        "CU",
        "CK",
        "KW",
        "CN",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "GB",
        "LT",
        "LI",
        "LU",
        "MG",
        "YT",
        "MO",
        "MK",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "MX",
        "ME",
        "IM",
        "FM",
        "MM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NL",
        "AN",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "QO",
        "AX",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "EH",
        "RW",
        "RO",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SC",
        "BL",
        "SN",
        "MF",
        "PM",
        "KN",
        "LC",
        "VC",
        "RS",
        "CS",
        "EA",
        "SG",
        "SY",
        "SL",
        "SK",
        "SI",
        "SO",
        "FI",
        "ES",
        "SS",
        "SD",
        "SR",
        "SH",
        "SJ",
        "SZ",
        "SX",
        "LK",
        "CH",
        "TJ",
        "TW",
        "TH",
        "TZ",
        "TC",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "HU",
        "UY",
        "UZ",
        "DE",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "SB",
        "ZM",
        "KP",
        "MP",
        "CX",
        "ZW",
        "SE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "pasaule");
    namesMap.put("002", "Āfrika");
    namesMap.put("003", "Ziemeļamerika");
    namesMap.put("005", "Dienvidamerika");
    namesMap.put("009", "Okeānija");
    namesMap.put("011", "Rietumāfrika");
    namesMap.put("013", "Centrālamerika");
    namesMap.put("014", "Austrumāfrika");
    namesMap.put("015", "Ziemeļāfrika");
    namesMap.put("017", "Vidusāfrika");
    namesMap.put("018", "Āfrikas dienvidi");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerikas ziemeļi");
    namesMap.put("029", "Karību jūras reģions");
    namesMap.put("030", "Austrumāzija");
    namesMap.put("034", "Dienvidāzija");
    namesMap.put("035", "Centrālaustrumāzija");
    namesMap.put("039", "Dienvideiropa");
    namesMap.put("053", "Austrālija un Jaunzēlande");
    namesMap.put("054", "Melanēzija");
    namesMap.put("057", "Mikronēzijas reģions");
    namesMap.put("061", "Polinēzija");
    namesMap.put("142", "Āzija");
    namesMap.put("143", "Centrālāzija");
    namesMap.put("145", "Rietumāzija");
    namesMap.put("150", "Eiropa");
    namesMap.put("151", "Austrumeiropa");
    namesMap.put("154", "Ziemeļeiropa");
    namesMap.put("155", "Rietumeiropa");
    namesMap.put("419", "Latīņamerika");
    namesMap.put("AC", "Debesbraukšanas sala");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Apvienotie Arābu Emirāti");
    namesMap.put("AF", "Afganistāna");
    namesMap.put("AG", "Antigva un Barbuda");
    namesMap.put("AI", "Angilja");
    namesMap.put("AL", "Albānija");
    namesMap.put("AM", "Armēnija");
    namesMap.put("AN", "Nīderlandes Antiļas");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AR", "Argentīna");
    namesMap.put("AS", "Amerikāņu Samoa");
    namesMap.put("AT", "Austrija");
    namesMap.put("AU", "Austrālija");
    namesMap.put("AX", "Olandes salas");
    namesMap.put("AZ", "Azerbaidžāna");
    namesMap.put("BA", "Bosnija un Hercegovina");
    namesMap.put("BB", "Barbadosa");
    namesMap.put("BD", "Bangladeša");
    namesMap.put("BE", "Beļģija");
    namesMap.put("BF", "Burkinafaso");
    namesMap.put("BG", "Bulgārija");
    namesMap.put("BH", "Bahreina");
    namesMap.put("BJ", "Benina");
    namesMap.put("BL", "Senbartelmī");
    namesMap.put("BM", "Bermudu salas");
    namesMap.put("BN", "Bruneja");
    namesMap.put("BO", "Bolīvija");
    namesMap.put("BR", "Brazīlija");
    namesMap.put("BS", "Bahamu salas");
    namesMap.put("BT", "Butāna");
    namesMap.put("BV", "Buvē sala");
    namesMap.put("BW", "Botsvāna");
    namesMap.put("BY", "Baltkrievija");
    namesMap.put("BZ", "Beliza");
    namesMap.put("CA", "Kanāda");
    namesMap.put("CC", "Kokosu jeb Kīlinga salas");
    namesMap.put("CD", "Kongo-Kinšasa");
    namesMap.put("CF", "Centrālāfrikas Republika");
    namesMap.put("CG", "Kongo - Brazavila");
    namesMap.put("CH", "Šveice");
    namesMap.put("CI", "Kotdivuāra");
    namesMap.put("CK", "Kuka salas");
    namesMap.put("CL", "Čīle");
    namesMap.put("CM", "Kamerūna");
    namesMap.put("CN", "Ķīna");
    namesMap.put("CO", "Kolumbija");
    namesMap.put("CP", "Klipertona sala");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CS", "Serbija un Melnkalne");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kaboverde");
    namesMap.put("CX", "Ziemsvētku sala");
    namesMap.put("CY", "Kipra");
    namesMap.put("CZ", "Čehija");
    namesMap.put("DE", "Vācija");
    namesMap.put("DG", "Djego Garsijas atols");
    namesMap.put("DJ", "Džibutija");
    namesMap.put("DK", "Dānija");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikānas Republika");
    namesMap.put("DZ", "Alžīrija");
    namesMap.put("EA", "Seūta un Meliļa");
    namesMap.put("EC", "Ekvadora");
    namesMap.put("EE", "Igaunija");
    namesMap.put("EG", "Ēģipte");
    namesMap.put("EH", "Rietumsahāra");
    namesMap.put("ER", "Eritreja");
    namesMap.put("ES", "Spānija");
    namesMap.put("ET", "Etiopija");
    namesMap.put("EU", "Eiropas Savienība");
    namesMap.put("FI", "Somija");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Folklenda salas");
    namesMap.put("FM", "Mikronēzija");
    namesMap.put("FO", "Fēru Salas");
    namesMap.put("FR", "Francija");
    namesMap.put("GA", "Gabona");
    namesMap.put("GB", "Lielbritānija");
    namesMap.put("GD", "Grenāda");
    namesMap.put("GE", "Gruzija");
    namesMap.put("GF", "Franču Gviāna");
    namesMap.put("GG", "Gērnsija");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Gibraltārs");
    namesMap.put("GL", "Grenlande");
    namesMap.put("GM", "Gambija");
    namesMap.put("GN", "Gvineja");
    namesMap.put("GP", "Gvadelupa");
    namesMap.put("GQ", "Ekvatoriālā Gvineja");
    namesMap.put("GR", "Grieķija");
    namesMap.put("GS", "Dienviddžordžija un Dienvidsendviču salas");
    namesMap.put("GT", "Gvatemala");
    namesMap.put("GU", "Guama");
    namesMap.put("GW", "Gvineja-Bisava");
    namesMap.put("GY", "Gajāna");
    namesMap.put("HK", "Honkonga");
    namesMap.put("HM", "Hērda un Makdonalda salas");
    namesMap.put("HN", "Hondurasa");
    namesMap.put("HR", "Horvātija");
    namesMap.put("HU", "Ungārija");
    namesMap.put("IC", "Kanāriju salas");
    namesMap.put("ID", "Indonēzija");
    namesMap.put("IE", "Īrija");
    namesMap.put("IL", "Izraēla");
    namesMap.put("IM", "Mena");
    namesMap.put("IN", "Indija");
    namesMap.put("IO", "Indijas okeāna Britu teritorija");
    namesMap.put("IQ", "Irāka");
    namesMap.put("IR", "Irāna");
    namesMap.put("IS", "Īslande");
    namesMap.put("IT", "Itālija");
    namesMap.put("JE", "Džērsija");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordānija");
    namesMap.put("JP", "Japāna");
    namesMap.put("KE", "Kenija");
    namesMap.put("KG", "Kirgīzija");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komoru salas");
    namesMap.put("KN", "Sentkitsa un Nevisa");
    namesMap.put("KP", "Ziemeļkoreja");
    namesMap.put("KR", "Dienvidkoreja");
    namesMap.put("KW", "Kuveita");
    namesMap.put("KY", "Kaimanu salas");
    namesMap.put("KZ", "Kazahstāna");
    namesMap.put("LA", "Laosa");
    namesMap.put("LB", "Libāna");
    namesMap.put("LC", "Sentlūsija");
    namesMap.put("LI", "Lihtenšteina");
    namesMap.put("LK", "Šrilanka");
    namesMap.put("LR", "Libērija");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lietuva");
    namesMap.put("LU", "Luksemburga");
    namesMap.put("LV", "Latvija");
    namesMap.put("LY", "Lībija");
    namesMap.put("MA", "Maroka");
    namesMap.put("MC", "Monako");
    namesMap.put("ME", "Melnkalne");
    namesMap.put("MF", "Senmartēna");
    namesMap.put("MG", "Madagaskara");
    namesMap.put("MH", "Māršala salas");
    namesMap.put("MK", "Maķedonija");
    namesMap.put("MM", "Mjanma [Birma]");
    namesMap.put("MN", "Mongolija");
    namesMap.put("MO", "Makao");
    namesMap.put("MP", "Ziemeļu Marianas salas");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MR", "Mauritānija");
    namesMap.put("MS", "Montserrata");
    namesMap.put("MU", "Maurīcija");
    namesMap.put("MV", "Maldīvija");
    namesMap.put("MW", "Malāvija");
    namesMap.put("MX", "Meksika");
    namesMap.put("MY", "Malaizija");
    namesMap.put("MZ", "Mozambika");
    namesMap.put("NA", "Namībija");
    namesMap.put("NC", "Jaunkaledonija");
    namesMap.put("NE", "Nigēra");
    namesMap.put("NF", "Norfolkas sala");
    namesMap.put("NG", "Nigērija");
    namesMap.put("NI", "Nikaragva");
    namesMap.put("NL", "Nīderlande");
    namesMap.put("NO", "Norvēģija");
    namesMap.put("NP", "Nepāla");
    namesMap.put("NZ", "Jaunzēlande");
    namesMap.put("OM", "Omāna");
    namesMap.put("PF", "Franču Polinēzija");
    namesMap.put("PG", "Papua-Jaungvineja");
    namesMap.put("PH", "Filipīnas");
    namesMap.put("PK", "Pakistāna");
    namesMap.put("PL", "Polija");
    namesMap.put("PM", "Senpjēra un Mikelona");
    namesMap.put("PN", "Pitkērna");
    namesMap.put("PR", "Puertoriko");
    namesMap.put("PS", "Palestīna");
    namesMap.put("PT", "Portugāle");
    namesMap.put("PY", "Paragvaja");
    namesMap.put("QA", "Katara");
    namesMap.put("QO", "Okeānijas attālās salas");
    namesMap.put("RE", "Reinjona");
    namesMap.put("RO", "Rumānija");
    namesMap.put("RS", "Serbija");
    namesMap.put("RU", "Krievija");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saūda Arābija");
    namesMap.put("SB", "Zālamana salas");
    namesMap.put("SC", "Seišeļu salas");
    namesMap.put("SD", "Sudāna");
    namesMap.put("SE", "Zviedrija");
    namesMap.put("SG", "Singapūra");
    namesMap.put("SH", "Sv. Helēnas sala");
    namesMap.put("SI", "Slovēnija");
    namesMap.put("SJ", "Svalbāra un Jana Majena sala");
    namesMap.put("SK", "Slovākija");
    namesMap.put("SL", "Sjerraleone");
    namesMap.put("SM", "Sanmarīno");
    namesMap.put("SN", "Senegāla");
    namesMap.put("SO", "Somālija");
    namesMap.put("SR", "Surinama");
    namesMap.put("ST", "Santome un Prinsipi");
    namesMap.put("SV", "Salvadora");
    namesMap.put("SY", "Sīrija");
    namesMap.put("SZ", "Svazilenda");
    namesMap.put("TA", "Tristana da Kuņas salas");
    namesMap.put("TC", "Tērksas un Kaikosas salas");
    namesMap.put("TD", "Čada");
    namesMap.put("TF", "Franču dienvidu teritorijas");
    namesMap.put("TH", "Taizeme");
    namesMap.put("TJ", "Tadžikistāna");
    namesMap.put("TL", "Austrumtimora");
    namesMap.put("TM", "Turkmenistāna");
    namesMap.put("TN", "Tunisija");
    namesMap.put("TR", "Turcija");
    namesMap.put("TT", "Trinidāda un Tobāgo");
    namesMap.put("TW", "Taivāna");
    namesMap.put("TZ", "Tanzānija");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "ASV Mazās Aizjūras salas");
    namesMap.put("US", "Amerikas Savienotās Valstis");
    namesMap.put("UY", "Urugvaja");
    namesMap.put("UZ", "Uzbekistāna");
    namesMap.put("VA", "Vatikāns");
    namesMap.put("VC", "Sentvinsenta un Grenadīnas");
    namesMap.put("VE", "Venecuēla");
    namesMap.put("VG", "Britu Virdžīnas");
    namesMap.put("VI", "ASV Virdžīnas");
    namesMap.put("VN", "Vjetnama");
    namesMap.put("WF", "Volisa un Futuna");
    namesMap.put("YE", "Jemena");
    namesMap.put("YT", "Majota");
    namesMap.put("ZA", "Dienvidāfrikas Republika");
    namesMap.put("ZM", "Zambija");
    namesMap.put("ZW", "Zimbabve");
    namesMap.put("ZZ", "nezināms vai nederīgs reģions");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "pasaule",
        "002": "Āfrika",
        "003": "Ziemeļamerika",
        "005": "Dienvidamerika",
        "009": "Okeānija",
        "011": "Rietumāfrika",
        "013": "Centrālamerika",
        "014": "Austrumāfrika",
        "015": "Ziemeļāfrika",
        "017": "Vidusāfrika",
        "018": "Āfrikas dienvidi",
        "019": "Amerika",
        "021": "Amerikas ziemeļi",
        "029": "Karību jūras reģions",
        "030": "Austrumāzija",
        "034": "Dienvidāzija",
        "035": "Centrālaustrumāzija",
        "039": "Dienvideiropa",
        "053": "Austrālija un Jaunzēlande",
        "054": "Melanēzija",
        "057": "Mikronēzijas reģions",
        "061": "Polinēzija",
        "142": "Āzija",
        "143": "Centrālāzija",
        "145": "Rietumāzija",
        "150": "Eiropa",
        "151": "Austrumeiropa",
        "154": "Ziemeļeiropa",
        "155": "Rietumeiropa",
        "419": "Latīņamerika",
        "AC": "Debesbraukšanas sala",
        "AD": "Andora",
        "AE": "Apvienotie Arābu Emirāti",
        "AF": "Afganistāna",
        "AG": "Antigva un Barbuda",
        "AI": "Angilja",
        "AL": "Albānija",
        "AM": "Armēnija",
        "AN": "Nīderlandes Antiļas",
        "AQ": "Antarktika",
        "AR": "Argentīna",
        "AS": "Amerikāņu Samoa",
        "AT": "Austrija",
        "AU": "Austrālija",
        "AX": "Olandes salas",
        "AZ": "Azerbaidžāna",
        "BA": "Bosnija un Hercegovina",
        "BB": "Barbadosa",
        "BD": "Bangladeša",
        "BE": "Beļģija",
        "BF": "Burkinafaso",
        "BG": "Bulgārija",
        "BH": "Bahreina",
        "BJ": "Benina",
        "BL": "Senbartelmī",
        "BM": "Bermudu salas",
        "BN": "Bruneja",
        "BO": "Bolīvija",
        "BR": "Brazīlija",
        "BS": "Bahamu salas",
        "BT": "Butāna",
        "BV": "Buvē sala",
        "BW": "Botsvāna",
        "BY": "Baltkrievija",
        "BZ": "Beliza",
        "CA": "Kanāda",
        "CC": "Kokosu jeb Kīlinga salas",
        "CD": "Kongo-Kinšasa",
        "CF": "Centrālāfrikas Republika",
        "CG": "Kongo - Brazavila",
        "CH": "Šveice",
        "CI": "Kotdivuāra",
        "CK": "Kuka salas",
        "CL": "Čīle",
        "CM": "Kamerūna",
        "CN": "Ķīna",
        "CO": "Kolumbija",
        "CP": "Klipertona sala",
        "CR": "Kostarika",
        "CS": "Serbija un Melnkalne",
        "CU": "Kuba",
        "CV": "Kaboverde",
        "CX": "Ziemsvētku sala",
        "CY": "Kipra",
        "CZ": "Čehija",
        "DE": "Vācija",
        "DG": "Djego Garsijas atols",
        "DJ": "Džibutija",
        "DK": "Dānija",
        "DM": "Dominika",
        "DO": "Dominikānas Republika",
        "DZ": "Alžīrija",
        "EA": "Seūta un Meliļa",
        "EC": "Ekvadora",
        "EE": "Igaunija",
        "EG": "Ēģipte",
        "EH": "Rietumsahāra",
        "ER": "Eritreja",
        "ES": "Spānija",
        "ET": "Etiopija",
        "EU": "Eiropas Savienība",
        "FI": "Somija",
        "FJ": "Fidži",
        "FK": "Folklenda salas",
        "FM": "Mikronēzija",
        "FO": "Fēru Salas",
        "FR": "Francija",
        "GA": "Gabona",
        "GB": "Lielbritānija",
        "GD": "Grenāda",
        "GE": "Gruzija",
        "GF": "Franču Gviāna",
        "GG": "Gērnsija",
        "GH": "Gana",
        "GI": "Gibraltārs",
        "GL": "Grenlande",
        "GM": "Gambija",
        "GN": "Gvineja",
        "GP": "Gvadelupa",
        "GQ": "Ekvatoriālā Gvineja",
        "GR": "Grieķija",
        "GS": "Dienviddžordžija un Dienvidsendviču salas",
        "GT": "Gvatemala",
        "GU": "Guama",
        "GW": "Gvineja-Bisava",
        "GY": "Gajāna",
        "HK": "Honkonga",
        "HM": "Hērda un Makdonalda salas",
        "HN": "Hondurasa",
        "HR": "Horvātija",
        "HU": "Ungārija",
        "IC": "Kanāriju salas",
        "ID": "Indonēzija",
        "IE": "Īrija",
        "IL": "Izraēla",
        "IM": "Mena",
        "IN": "Indija",
        "IO": "Indijas okeāna Britu teritorija",
        "IQ": "Irāka",
        "IR": "Irāna",
        "IS": "Īslande",
        "IT": "Itālija",
        "JE": "Džērsija",
        "JM": "Jamaika",
        "JO": "Jordānija",
        "JP": "Japāna",
        "KE": "Kenija",
        "KG": "Kirgīzija",
        "KH": "Kambodža",
        "KM": "Komoru salas",
        "KN": "Sentkitsa un Nevisa",
        "KP": "Ziemeļkoreja",
        "KR": "Dienvidkoreja",
        "KW": "Kuveita",
        "KY": "Kaimanu salas",
        "KZ": "Kazahstāna",
        "LA": "Laosa",
        "LB": "Libāna",
        "LC": "Sentlūsija",
        "LI": "Lihtenšteina",
        "LK": "Šrilanka",
        "LR": "Libērija",
        "LS": "Lesoto",
        "LT": "Lietuva",
        "LU": "Luksemburga",
        "LV": "Latvija",
        "LY": "Lībija",
        "MA": "Maroka",
        "MC": "Monako",
        "ME": "Melnkalne",
        "MF": "Senmartēna",
        "MG": "Madagaskara",
        "MH": "Māršala salas",
        "MK": "Maķedonija",
        "MM": "Mjanma [Birma]",
        "MN": "Mongolija",
        "MO": "Makao",
        "MP": "Ziemeļu Marianas salas",
        "MQ": "Martinika",
        "MR": "Mauritānija",
        "MS": "Montserrata",
        "MU": "Maurīcija",
        "MV": "Maldīvija",
        "MW": "Malāvija",
        "MX": "Meksika",
        "MY": "Malaizija",
        "MZ": "Mozambika",
        "NA": "Namībija",
        "NC": "Jaunkaledonija",
        "NE": "Nigēra",
        "NF": "Norfolkas sala",
        "NG": "Nigērija",
        "NI": "Nikaragva",
        "NL": "Nīderlande",
        "NO": "Norvēģija",
        "NP": "Nepāla",
        "NZ": "Jaunzēlande",
        "OM": "Omāna",
        "PF": "Franču Polinēzija",
        "PG": "Papua-Jaungvineja",
        "PH": "Filipīnas",
        "PK": "Pakistāna",
        "PL": "Polija",
        "PM": "Senpjēra un Mikelona",
        "PN": "Pitkērna",
        "PR": "Puertoriko",
        "PS": "Palestīna",
        "PT": "Portugāle",
        "PY": "Paragvaja",
        "QA": "Katara",
        "QO": "Okeānijas attālās salas",
        "RE": "Reinjona",
        "RO": "Rumānija",
        "RS": "Serbija",
        "RU": "Krievija",
        "RW": "Ruanda",
        "SA": "Saūda Arābija",
        "SB": "Zālamana salas",
        "SC": "Seišeļu salas",
        "SD": "Sudāna",
        "SE": "Zviedrija",
        "SG": "Singapūra",
        "SH": "Sv. Helēnas sala",
        "SI": "Slovēnija",
        "SJ": "Svalbāra un Jana Majena sala",
        "SK": "Slovākija",
        "SL": "Sjerraleone",
        "SM": "Sanmarīno",
        "SN": "Senegāla",
        "SO": "Somālija",
        "SR": "Surinama",
        "ST": "Santome un Prinsipi",
        "SV": "Salvadora",
        "SY": "Sīrija",
        "SZ": "Svazilenda",
        "TA": "Tristana da Kuņas salas",
        "TC": "Tērksas un Kaikosas salas",
        "TD": "Čada",
        "TF": "Franču dienvidu teritorijas",
        "TH": "Taizeme",
        "TJ": "Tadžikistāna",
        "TL": "Austrumtimora",
        "TM": "Turkmenistāna",
        "TN": "Tunisija",
        "TR": "Turcija",
        "TT": "Trinidāda un Tobāgo",
        "TW": "Taivāna",
        "TZ": "Tanzānija",
        "UA": "Ukraina",
        "UM": "ASV Mazās Aizjūras salas",
        "US": "Amerikas Savienotās Valstis",
        "UY": "Urugvaja",
        "UZ": "Uzbekistāna",
        "VA": "Vatikāns",
        "VC": "Sentvinsenta un Grenadīnas",
        "VE": "Venecuēla",
        "VG": "Britu Virdžīnas",
        "VI": "ASV Virdžīnas",
        "VN": "Vjetnama",
        "WF": "Volisa un Futuna",
        "YE": "Jemena",
        "YT": "Majota",
        "ZA": "Dienvidāfrikas Republika",
        "ZM": "Zambija",
        "ZW": "Zimbabve",
        "ZZ": "nezināms vai nederīgs reģions"
    };
  }-*/;
}
