/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-13 05:14:13 +0100 (Thu, 13 Feb 2014) $
//  number=$Revision: 9728 $
//  type=sg

/**
 * Localized names for the "sg" locale.
 */
public class LocalizedNamesImpl_sg extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AL",
        "US",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AG",
        "AN",
        "AQ",
        "AE",
        "AM",
        "AW",
        "AR",
        "AX",
        "VG",
        "CK",
        "MP",
        "MH",
        "KY",
        "CV",
        "FK",
        "TC",
        "VI",
        "BS",
        "BH",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BD",
        "BM",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "CC",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EA",
        "EH",
        "EC",
        "IN",
        "ID",
        "ER",
        "ES",
        "EE",
        "ET",
        "EU",
        "AF",
        "FR",
        "FI",
        "FJ",
        "PH",
        "NC",
        "NZ",
        "FO",
        "GA",
        "GM",
        "GH",
        "GY",
        "GR",
        "GG",
        "GN",
        "GQ",
        "GW",
        "GL",
        "GD",
        "GS",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "HK",
        "HM",
        "NL",
        "HN",
        "HU",
        "IC",
        "IM",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "JE",
        "KH",
        "CM",
        "EG",
        "CA",
        "QA",
        "KZ",
        "KE",
        "KI",
        "KG",
        "CI",
        "GB",
        "CF",
        "DO",
        "CD",
        "CZ",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CR",
        "KW",
        "HR",
        "CU",
        "LS",
        "VA",
        "LV",
        "LR",
        "LY",
        "LB",
        "LI",
        "LT",
        "LA",
        "LU",
        "MG",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MK",
        "YT",
        "ZA",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MU",
        "MR",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NU",
        "NE",
        "NG",
        "NO",
        "OM",
        "AU",
        "AT",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PR",
        "PT",
        "QO",
        "RE",
        "RS",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "AS",
        "ST",
        "SA",
        "SN",
        "KN",
        "SM",
        "PM",
        "SH",
        "LC",
        "VC",
        "IO",
        "PS",
        "SC",
        "CL",
        "CN",
        "SL",
        "SG",
        "CY",
        "SY",
        "LK",
        "SJ",
        "SK",
        "SI",
        "SO",
        "SD",
        "SS",
        "SE",
        "CH",
        "SR",
        "SZ",
        "SX",
        "TA",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TM",
        "TR",
        "TV",
        "TD",
        "UG",
        "UA",
        "UM",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "XK",
        "YE",
        "JM",
        "DE",
        "ZM",
        "JP",
        "AZ",
        "GI",
        "ZW",
        "JO",
        "GE",
        "NF",
        "SB",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andôro");
    namesMap.put("AE", "Arâbo Emirâti Ôko");
    namesMap.put("AF", "Faganïta, Afganïstäan");
    namesMap.put("AG", "Antîgua na Barbûda");
    namesMap.put("AI", "Angûîla");
    namesMap.put("AL", "Albanïi");
    namesMap.put("AM", "Armenïi");
    namesMap.put("AN", "Antîyi tî Holânde");
    namesMap.put("AO", "Angoläa");
    namesMap.put("AR", "Arzantîna");
    namesMap.put("AS", "Samöa tî Amerîka");
    namesMap.put("AT", "Otrîsi");
    namesMap.put("AU", "Ostralïi, Sotralïi");
    namesMap.put("AW", "Arûba");
    namesMap.put("AZ", "Zerebaidyäan, Azerbaidyäan,");
    namesMap.put("BA", "Bosnïi na Herzegovînni");
    namesMap.put("BB", "Barabâda");
    namesMap.put("BD", "Bengladêshi");
    namesMap.put("BE", "Bêleze, Belezîki");
    namesMap.put("BG", "Bulugarïi");
    namesMap.put("BH", "Bahrâina");
    namesMap.put("BI", "Burundïi");
    namesMap.put("BJ", "Benëen");
    namesMap.put("BM", "Beremûda");
    namesMap.put("BN", "Brunêi");
    namesMap.put("BO", "Bolivïi");
    namesMap.put("BR", "Brezîli");
    namesMap.put("BS", "Bahâmasa");
    namesMap.put("BT", "Butäan");
    namesMap.put("BY", "Belarüsi");
    namesMap.put("BZ", "Belîzi");
    namesMap.put("CA", "Kanadäa");
    namesMap.put("CD", "Ködörösêse tî Ngunuhalëzo tî kongö");
    namesMap.put("CF", "Ködörösêse tî Bêafrîka");
    namesMap.put("CG", "Kongö");
    namesMap.put("CH", "Sûîsi");
    namesMap.put("CI", "Kôdivüära");
    namesMap.put("CK", "âzûâ Kûku");
    namesMap.put("CL", "Shilïi");
    namesMap.put("CM", "Kamerûne");
    namesMap.put("CN", "Shîna");
    namesMap.put("CO", "Kolombïi");
    namesMap.put("CR", "Kôsta Rîka");
    namesMap.put("CU", "Kubäa");
    namesMap.put("CV", "Azûâ tî Kâpo-Vêre");
    namesMap.put("CY", "Sîpri");
    namesMap.put("CZ", "Ködörösêse tî Tyêki");
    namesMap.put("DE", "Zâmani");
    namesMap.put("DJ", "Dibutùii");
    namesMap.put("DK", "Danemêrke");
    namesMap.put("DM", "Dömïnîka");
    namesMap.put("DO", "Ködörösêse tî Dominîka");
    namesMap.put("DZ", "Alzerïi");
    namesMap.put("EC", "Ekuatëre");
    namesMap.put("EE", "Estonïi");
    namesMap.put("EG", "Kâmitâ");
    namesMap.put("ER", "Eritrëe");
    namesMap.put("ES", "Espânye");
    namesMap.put("ET", "Etiopïi");
    namesMap.put("FI", "Fëlânde");
    namesMap.put("FJ", "Fidyïi");
    namesMap.put("FK", "Âzûâ tî Mälüîni");
    namesMap.put("FM", "Mikronezïi");
    namesMap.put("FR", "Farânzi");
    namesMap.put("GA", "Gaböon");
    namesMap.put("GB", "Ködörögbïä--Ôko");
    namesMap.put("GD", "Grenâda");
    namesMap.put("GE", "Zorzïi");
    namesMap.put("GF", "Güyâni tî farânzi");
    namesMap.put("GH", "Ganäa");
    namesMap.put("GI", "Zibraltära, Zibaratära");
    namesMap.put("GL", "Gorolânde");
    namesMap.put("GM", "Gambïi");
    namesMap.put("GN", "Ginëe");
    namesMap.put("GP", "Guadelûpu");
    namesMap.put("GQ", "Ginëe tî Ekuatëre");
    namesMap.put("GR", "Gerêsi");
    namesMap.put("GT", "Guatêmälä");
    namesMap.put("GU", "Guâm");
    namesMap.put("GW", "Gninëe-Bisau");
    namesMap.put("GY", "Gayâna");
    namesMap.put("HN", "Honduräsi");
    namesMap.put("HR", "Kroasïi");
    namesMap.put("HT", "Haitïi");
    namesMap.put("HU", "Hongirùii");
    namesMap.put("ID", "Ênndonezïi");
    namesMap.put("IE", "Irlânde");
    namesMap.put("IL", "Israëli");
    namesMap.put("IN", "Ênnde");
    namesMap.put("IO", "Sêse tî Anglëe na Ngûyämä tî Ênnde");
    namesMap.put("IQ", "Irâki");
    namesMap.put("IR", "Iräan");
    namesMap.put("IS", "Islânde");
    namesMap.put("IT", "Italùii");
    namesMap.put("JM", "Zamaîka");
    namesMap.put("JO", "Zordanïi");
    namesMap.put("JP", "Zapöon");
    namesMap.put("KE", "Kenyäa");
    namesMap.put("KG", "Kirigizitùaan");
    namesMap.put("KH", "Kämbôzi");
    namesMap.put("KM", "Kömôro");
    namesMap.put("KN", "Sên-Krïstôfo-na-Nevîsi");
    namesMap.put("KP", "Korëe tî Banga");
    namesMap.put("KR", "Korëe tî Mbongo");
    namesMap.put("KW", "Köwêti");
    namesMap.put("KY", "Âzûâ Ngundë, Kaimäni");
    namesMap.put("KZ", "Kazakisitäan");
    namesMap.put("LA", "Lùaôsi");
    namesMap.put("LB", "Libùaan");
    namesMap.put("LC", "Sênt-Lisïi");
    namesMap.put("LI", "Liechtenstein,");
    namesMap.put("LK", "Sirî-Lanka");
    namesMap.put("LR", "Liberïa");
    namesMap.put("LS", "Lesôtho");
    namesMap.put("LT", "Lituanïi");
    namesMap.put("LU", "Lugzambûru");
    namesMap.put("LV", "Letonùii");
    namesMap.put("LY", "Libïi");
    namesMap.put("MA", "Marôko");
    namesMap.put("MC", "Monaköo");
    namesMap.put("MD", "Moldavùii");
    namesMap.put("MG", "Madagaskära");
    namesMap.put("MH", "Âzûâ Märshâl");
    namesMap.put("MK", "Maseduäni");
    namesMap.put("ML", "Malïi");
    namesMap.put("MM", "Myämâra");
    namesMap.put("MN", "Mongolïi");
    namesMap.put("MP", "Âzûâ Märïâni tî Banga");
    namesMap.put("MQ", "Märtïnîki");
    namesMap.put("MR", "Moritanïi");
    namesMap.put("MS", "Monserâte");
    namesMap.put("MT", "Mâlta");
    namesMap.put("MU", "Mörîsi");
    namesMap.put("MV", "Maldîva");
    namesMap.put("MW", "Malawïi");
    namesMap.put("MX", "Mekisîki");
    namesMap.put("MY", "Malezïi");
    namesMap.put("MZ", "Mözämbîka");
    namesMap.put("NA", "Namibùii");
    namesMap.put("NC", "Finî Kaledonïi");
    namesMap.put("NE", "Nizëre");
    namesMap.put("NF", "Zûâ Nôrfôlko");
    namesMap.put("NG", "Nizerïa");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Holände");
    namesMap.put("NO", "Nörvêzi");
    namesMap.put("NP", "Nëpâli");
    namesMap.put("NZ", "Finî Zelânde");
    namesMap.put("OM", "Omâni");
    namesMap.put("PE", "Perüu");
    namesMap.put("PF", "Polinezïi tî farânzi");
    namesMap.put("PG", "Papû Finî Ginëe, Papuazïi");
    namesMap.put("PH", "Filipîni");
    namesMap.put("PK", "Pakistäan");
    namesMap.put("PL", "Pölôni");
    namesMap.put("PM", "Sên-Pyêre na Mikelöon");
    namesMap.put("PN", "Pitikêrni");
    namesMap.put("PR", "Porto Rîko");
    namesMap.put("PS", "Sêse tî Palestîni");
    namesMap.put("PT", "Pörtugäle, Ködörö Pûra");
    namesMap.put("PY", "Paraguëe");
    namesMap.put("QA", "Katära");
    namesMap.put("RE", "Reinïon");
    namesMap.put("RO", "Rumanïi");
    namesMap.put("RU", "Rusïi");
    namesMap.put("RW", "Ruandäa");
    namesMap.put("SA", "Saûdi Arabïi");
    namesMap.put("SB", "Zûâ Salomöon");
    namesMap.put("SC", "Sëyshêle");
    namesMap.put("SD", "Sudäan");
    namesMap.put("SE", "Suêde");
    namesMap.put("SG", "Sïngäpûru");
    namesMap.put("SH", "Sênt-Helêna");
    namesMap.put("SI", "Solovenïi");
    namesMap.put("SK", "Solovakïi");
    namesMap.put("SL", "Sierä-Leône");
    namesMap.put("SM", "Sên-Marëen");
    namesMap.put("SN", "Senegäle");
    namesMap.put("SO", "Somalïi");
    namesMap.put("SR", "Surinäm");
    namesMap.put("SS", "Sudäan-Mbongo");
    namesMap.put("ST", "Sâô Tömê na Prinsîpe");
    namesMap.put("SV", "Salvadöro");
    namesMap.put("SY", "Sirïi");
    namesMap.put("SZ", "Swäzïlânde");
    namesMap.put("TC", "Âzûâ Turku na Kaîki");
    namesMap.put("TD", "Tyâde");
    namesMap.put("TG", "Togö");
    namesMap.put("TH", "Tailânde");
    namesMap.put("TJ", "Taazikiistäan");
    namesMap.put("TL", "Timôro tî Tö");
    namesMap.put("TM", "Turkumenistäan");
    namesMap.put("TN", "Tunizïi");
    namesMap.put("TR", "Turukïi");
    namesMap.put("TT", "Trinitùee na Tobagö");
    namesMap.put("TV", "Tüvalü");
    namesMap.put("TW", "Tâiwâni");
    namesMap.put("TZ", "Tanzanïi");
    namesMap.put("UA", "Ukrêni");
    namesMap.put("UG", "Ugandäa");
    namesMap.put("US", "ÂLeaa-Ôko tî Amerika");
    namesMap.put("UY", "Uruguëe");
    namesMap.put("UZ", "Uzbekistäan");
    namesMap.put("VA", "Letëe tî Vatikäan");
    namesMap.put("VC", "Sên-Vensäan na âGrenadîni");
    namesMap.put("VE", "Venezueläa");
    namesMap.put("VG", "Âzôâ Viîrîggo tî Anglëe");
    namesMap.put("VI", "Âzûâ Virîgo tî Amerîka");
    namesMap.put("VN", "Vietnäm");
    namesMap.put("VU", "Vanuatü");
    namesMap.put("WF", "Walîsi na Futuna");
    namesMap.put("WS", "Samoäa");
    namesMap.put("YE", "Yëmêni");
    namesMap.put("YT", "Mäyôte");
    namesMap.put("ZA", "Mbongo-Afrîka");
    namesMap.put("ZM", "Zambïi");
    namesMap.put("ZW", "Zimbäbwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andôro",
        "AE": "Arâbo Emirâti Ôko",
        "AF": "Faganïta, Afganïstäan",
        "AG": "Antîgua na Barbûda",
        "AI": "Angûîla",
        "AL": "Albanïi",
        "AM": "Armenïi",
        "AN": "Antîyi tî Holânde",
        "AO": "Angoläa",
        "AR": "Arzantîna",
        "AS": "Samöa tî Amerîka",
        "AT": "Otrîsi",
        "AU": "Ostralïi, Sotralïi",
        "AW": "Arûba",
        "AZ": "Zerebaidyäan, Azerbaidyäan,",
        "BA": "Bosnïi na Herzegovînni",
        "BB": "Barabâda",
        "BD": "Bengladêshi",
        "BE": "Bêleze, Belezîki",
        "BG": "Bulugarïi",
        "BH": "Bahrâina",
        "BI": "Burundïi",
        "BJ": "Benëen",
        "BM": "Beremûda",
        "BN": "Brunêi",
        "BO": "Bolivïi",
        "BR": "Brezîli",
        "BS": "Bahâmasa",
        "BT": "Butäan",
        "BY": "Belarüsi",
        "BZ": "Belîzi",
        "CA": "Kanadäa",
        "CD": "Ködörösêse tî Ngunuhalëzo tî kongö",
        "CF": "Ködörösêse tî Bêafrîka",
        "CG": "Kongö",
        "CH": "Sûîsi",
        "CI": "Kôdivüära",
        "CK": "âzûâ Kûku",
        "CL": "Shilïi",
        "CM": "Kamerûne",
        "CN": "Shîna",
        "CO": "Kolombïi",
        "CR": "Kôsta Rîka",
        "CU": "Kubäa",
        "CV": "Azûâ tî Kâpo-Vêre",
        "CY": "Sîpri",
        "CZ": "Ködörösêse tî Tyêki",
        "DE": "Zâmani",
        "DJ": "Dibutùii",
        "DK": "Danemêrke",
        "DM": "Dömïnîka",
        "DO": "Ködörösêse tî Dominîka",
        "DZ": "Alzerïi",
        "EC": "Ekuatëre",
        "EE": "Estonïi",
        "EG": "Kâmitâ",
        "ER": "Eritrëe",
        "ES": "Espânye",
        "ET": "Etiopïi",
        "FI": "Fëlânde",
        "FJ": "Fidyïi",
        "FK": "Âzûâ tî Mälüîni",
        "FM": "Mikronezïi",
        "FR": "Farânzi",
        "GA": "Gaböon",
        "GB": "Ködörögbïä--Ôko",
        "GD": "Grenâda",
        "GE": "Zorzïi",
        "GF": "Güyâni tî farânzi",
        "GH": "Ganäa",
        "GI": "Zibraltära, Zibaratära",
        "GL": "Gorolânde",
        "GM": "Gambïi",
        "GN": "Ginëe",
        "GP": "Guadelûpu",
        "GQ": "Ginëe tî Ekuatëre",
        "GR": "Gerêsi",
        "GT": "Guatêmälä",
        "GU": "Guâm",
        "GW": "Gninëe-Bisau",
        "GY": "Gayâna",
        "HN": "Honduräsi",
        "HR": "Kroasïi",
        "HT": "Haitïi",
        "HU": "Hongirùii",
        "ID": "Ênndonezïi",
        "IE": "Irlânde",
        "IL": "Israëli",
        "IN": "Ênnde",
        "IO": "Sêse tî Anglëe na Ngûyämä tî Ênnde",
        "IQ": "Irâki",
        "IR": "Iräan",
        "IS": "Islânde",
        "IT": "Italùii",
        "JM": "Zamaîka",
        "JO": "Zordanïi",
        "JP": "Zapöon",
        "KE": "Kenyäa",
        "KG": "Kirigizitùaan",
        "KH": "Kämbôzi",
        "KM": "Kömôro",
        "KN": "Sên-Krïstôfo-na-Nevîsi",
        "KP": "Korëe tî Banga",
        "KR": "Korëe tî Mbongo",
        "KW": "Köwêti",
        "KY": "Âzûâ Ngundë, Kaimäni",
        "KZ": "Kazakisitäan",
        "LA": "Lùaôsi",
        "LB": "Libùaan",
        "LC": "Sênt-Lisïi",
        "LI": "Liechtenstein,",
        "LK": "Sirî-Lanka",
        "LR": "Liberïa",
        "LS": "Lesôtho",
        "LT": "Lituanïi",
        "LU": "Lugzambûru",
        "LV": "Letonùii",
        "LY": "Libïi",
        "MA": "Marôko",
        "MC": "Monaköo",
        "MD": "Moldavùii",
        "MG": "Madagaskära",
        "MH": "Âzûâ Märshâl",
        "MK": "Maseduäni",
        "ML": "Malïi",
        "MM": "Myämâra",
        "MN": "Mongolïi",
        "MP": "Âzûâ Märïâni tî Banga",
        "MQ": "Märtïnîki",
        "MR": "Moritanïi",
        "MS": "Monserâte",
        "MT": "Mâlta",
        "MU": "Mörîsi",
        "MV": "Maldîva",
        "MW": "Malawïi",
        "MX": "Mekisîki",
        "MY": "Malezïi",
        "MZ": "Mözämbîka",
        "NA": "Namibùii",
        "NC": "Finî Kaledonïi",
        "NE": "Nizëre",
        "NF": "Zûâ Nôrfôlko",
        "NG": "Nizerïa",
        "NI": "Nikaragua",
        "NL": "Holände",
        "NO": "Nörvêzi",
        "NP": "Nëpâli",
        "NZ": "Finî Zelânde",
        "OM": "Omâni",
        "PE": "Perüu",
        "PF": "Polinezïi tî farânzi",
        "PG": "Papû Finî Ginëe, Papuazïi",
        "PH": "Filipîni",
        "PK": "Pakistäan",
        "PL": "Pölôni",
        "PM": "Sên-Pyêre na Mikelöon",
        "PN": "Pitikêrni",
        "PR": "Porto Rîko",
        "PS": "Sêse tî Palestîni",
        "PT": "Pörtugäle, Ködörö Pûra",
        "PY": "Paraguëe",
        "QA": "Katära",
        "RE": "Reinïon",
        "RO": "Rumanïi",
        "RU": "Rusïi",
        "RW": "Ruandäa",
        "SA": "Saûdi Arabïi",
        "SB": "Zûâ Salomöon",
        "SC": "Sëyshêle",
        "SD": "Sudäan",
        "SE": "Suêde",
        "SG": "Sïngäpûru",
        "SH": "Sênt-Helêna",
        "SI": "Solovenïi",
        "SK": "Solovakïi",
        "SL": "Sierä-Leône",
        "SM": "Sên-Marëen",
        "SN": "Senegäle",
        "SO": "Somalïi",
        "SR": "Surinäm",
        "SS": "Sudäan-Mbongo",
        "ST": "Sâô Tömê na Prinsîpe",
        "SV": "Salvadöro",
        "SY": "Sirïi",
        "SZ": "Swäzïlânde",
        "TC": "Âzûâ Turku na Kaîki",
        "TD": "Tyâde",
        "TG": "Togö",
        "TH": "Tailânde",
        "TJ": "Taazikiistäan",
        "TL": "Timôro tî Tö",
        "TM": "Turkumenistäan",
        "TN": "Tunizïi",
        "TR": "Turukïi",
        "TT": "Trinitùee na Tobagö",
        "TV": "Tüvalü",
        "TW": "Tâiwâni",
        "TZ": "Tanzanïi",
        "UA": "Ukrêni",
        "UG": "Ugandäa",
        "US": "ÂLeaa-Ôko tî Amerika",
        "UY": "Uruguëe",
        "UZ": "Uzbekistäan",
        "VA": "Letëe tî Vatikäan",
        "VC": "Sên-Vensäan na âGrenadîni",
        "VE": "Venezueläa",
        "VG": "Âzôâ Viîrîggo tî Anglëe",
        "VI": "Âzûâ Virîgo tî Amerîka",
        "VN": "Vietnäm",
        "VU": "Vanuatü",
        "WF": "Walîsi na Futuna",
        "WS": "Samoäa",
        "YE": "Yëmêni",
        "YT": "Mäyôte",
        "ZA": "Mbongo-Afrîka",
        "ZM": "Zambïi",
        "ZW": "Zimbäbwe"
    };
  }-*/;
}
