/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.javanet.NetHttpResponse;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;

final class NetHttpRequest
extends LowLevelHttpRequest {
    private final HttpURLConnection connection;
    private HttpContent content;

    NetHttpRequest(HttpURLConnection connection) {
        this.connection = connection;
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
    }

    public void addHeader(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    public void setTimeout(int connectTimeout, int readTimeout) {
        this.connection.setReadTimeout(readTimeout);
        this.connection.setConnectTimeout(connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LowLevelHttpResponse execute() throws IOException {
        HttpURLConnection connection = this.connection;
        if (this.content != null) {
            String requestMethod;
            long contentLength;
            String contentEncoding;
            String contentType = this.content.getType();
            if (contentType != null) {
                this.addHeader("Content-Type", contentType);
            }
            if ((contentEncoding = this.content.getEncoding()) != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            if ((contentLength = this.content.getLength()) >= 0L) {
                this.addHeader("Content-Length", Long.toString(contentLength));
            }
            if ("POST".equals(requestMethod = connection.getRequestMethod()) || "PUT".equals(requestMethod)) {
                connection.setDoOutput(true);
                if (contentLength >= 0L && contentLength <= Integer.MAX_VALUE) {
                    connection.setFixedLengthStreamingMode((int)contentLength);
                } else {
                    connection.setChunkedStreamingMode(0);
                }
                OutputStream out = connection.getOutputStream();
                try {
                    this.content.writeTo(out);
                }
                finally {
                    out.close();
                }
            } else {
                Preconditions.checkArgument((contentLength == 0L ? 1 : 0) != 0, (String)"%s with non-zero content length is not supported", (Object[])new Object[]{requestMethod});
            }
        }
        boolean successfulConnection = false;
        try {
            connection.connect();
            NetHttpResponse response = new NetHttpResponse(connection);
            successfulConnection = true;
            NetHttpResponse netHttpResponse = response;
            return netHttpResponse;
        }
        finally {
            if (!successfulConnection) {
                connection.disconnect();
            }
        }
    }

    public void setContent(HttpContent content) {
        this.content = content;
    }
}

