/*
 * Copyright 2020 Google Inc. All rights reserved.
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this
 * file except in compliance with the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
 * ANY KIND, either express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.google.maps.internal;

/** Contains HTTP header name constants. */
public final class HttpHeaders {

  /** The HTTP {@code X-Goog-Maps-Experience-ID} header field name. */
  public static final String X_GOOG_MAPS_EXPERIENCE_ID = "X-Goog-Maps-Experience-ID";

  /** The HTTP {@code X-Android-Package} header field name. */
  public static final String X_ANDROID_PACKAGE = "X-Android-Package";

  /** The HTTP {@code X-Android-Cert} header field name. */
  public static final String X_ANDROID_CERT = "X-Android-Cert";
}
