/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.JavaFileObjects;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.tools.JavaFileObject;

final class MoreTrees {
    MoreTrees() {
    }

    static CompilationUnitTree parseLinesToTree(String ... source) {
        return MoreTrees.parseLinesToTree(Arrays.asList(source));
    }

    static CompilationUnitTree parseLinesToTree(Iterable<String> source) {
        Iterable<? extends CompilationUnitTree> parseResults = Compilation.parse((Iterable<? extends JavaFileObject>)ImmutableList.of((Object)JavaFileObjects.forSourceLines("", source))).compilationUnits();
        return (CompilationUnitTree)Iterables.getOnlyElement(parseResults);
    }

    static Compilation.ParseResult parseLines(String ... source) {
        return MoreTrees.parseLines(Arrays.asList(source));
    }

    static Compilation.ParseResult parseLines(Iterable<String> source) {
        return Compilation.parse((Iterable<? extends JavaFileObject>)ImmutableList.of((Object)JavaFileObjects.forSourceLines("", source)));
    }

    static Tree findSubtree(CompilationUnitTree root, Tree.Kind treeKind) {
        return MoreTrees.findSubtree(root, treeKind, null);
    }

    static Tree findSubtree(CompilationUnitTree root, Tree.Kind treeKind, @Nullable String identifier) {
        return MoreTrees.findSubtreePath(root, treeKind, identifier).getLeaf();
    }

    static TreePath findSubtreePath(CompilationUnitTree root, Tree.Kind treeKind) {
        return MoreTrees.findSubtreePath(root, treeKind, null);
    }

    static TreePath findSubtreePath(CompilationUnitTree root, Tree.Kind treeKind, @Nullable String identifier) {
        SearchScanner subtreeFinder = new SearchScanner(treeKind, (Optional<String>)(identifier == null ? Optional.absent() : Optional.of((Object)identifier)));
        Optional<TreePath> res = subtreeFinder.scan((Tree)root, null);
        Preconditions.checkArgument((boolean)res.isPresent(), (String)"Couldn't find any subtree matching the given criteria. Root: %s, Class: %s, Identifier: %s", (Object[])new Object[]{root, treeKind, identifier});
        return (TreePath)res.get();
    }

    static final class SearchScanner
    extends TreePathScanner<Optional<TreePath>, Void> {
        private final Optional<String> identifier;
        private final Tree.Kind kindSought;

        public SearchScanner(Tree.Kind kindSought, Optional<String> identifier) {
            this.kindSought = kindSought;
            this.identifier = identifier;
        }

        private boolean isMatch(Tree node, Optional<Object> idValue) {
            boolean idsMatch = !this.identifier.isPresent() ? true : (!idValue.isPresent() ? false : idValue.get() == null && this.identifier.get() == null || ((String)this.identifier.get()).equals(idValue.get().toString()));
            return this.kindSought.equals((Object)node.getKind()) && idsMatch;
        }

        private boolean isMatch(Tree node, Object idValue) {
            return this.isMatch(node, (Optional<Object>)Optional.fromNullable((Object)idValue));
        }

        private Optional<TreePath> currentPathPlus(Tree node) {
            return Optional.of((Object)new TreePath(this.getCurrentPath(), node));
        }

        private Optional<TreePath> absentIfNull(Optional<TreePath> ret) {
            return ret != null ? ret : Optional.absent();
        }

        @Override
        public Optional<TreePath> scan(Tree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            return this.isMatch(node, (Optional<Object>)Optional.absent()) ? this.currentPathPlus(node) : this.absentIfNull((Optional<TreePath>)((Optional)super.scan(node, v)));
        }

        @Override
        public Optional<TreePath> scan(Iterable<? extends Tree> nodes, Void v) {
            Optional ret = (Optional)super.scan(nodes, v);
            return ret != null ? ret : Optional.absent();
        }

        @Override
        public Optional<TreePath> reduce(Optional<TreePath> t1, Optional<TreePath> t2) {
            return t1.isPresent() ? t1 : t2;
        }

        @Override
        public Optional<TreePath> visitBreak(@Nullable BreakTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            return this.isMatch((Tree)node, node.getLabel()) ? this.currentPathPlus(node) : Optional.absent();
        }

        @Override
        public Optional<TreePath> visitClass(@Nullable ClassTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getSimpleName())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitClass(node, v);
        }

        @Override
        public Optional<TreePath> visitContinue(@Nullable ContinueTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getLabel())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitContinue(node, v);
        }

        @Override
        public Optional<TreePath> visitIdentifier(@Nullable IdentifierTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getName())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitIdentifier(node, v);
        }

        @Override
        public Optional<TreePath> visitLabeledStatement(@Nullable LabeledStatementTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getLabel())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitLabeledStatement(node, v);
        }

        @Override
        public Optional<TreePath> visitLiteral(@Nullable LiteralTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getValue())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitLiteral(node, v);
        }

        @Override
        public Optional<TreePath> visitMethod(@Nullable MethodTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getName())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitMethod(node, v);
        }

        @Override
        public Optional<TreePath> visitMemberSelect(@Nullable MemberSelectTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getIdentifier())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitMemberSelect(node, v);
        }

        @Override
        public Optional<TreePath> visitTypeParameter(@Nullable TypeParameterTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getName())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitTypeParameter(node, v);
        }

        @Override
        public Optional<TreePath> visitVariable(@Nullable VariableTree node, Void v) {
            if (node == null) {
                return Optional.absent();
            }
            if (this.isMatch((Tree)node, node.getName())) {
                return this.currentPathPlus(node);
            }
            return (Optional)super.visitVariable(node, v);
        }
    }
}

