/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Preconditions;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;

final class TreeContext {
    private final CompilationUnitTree compilationUnit;
    private final Trees trees;
    private final SourcePositions sourcePositions;
    private final LineMap lineMap;

    TreeContext(CompilationUnitTree compilationUnit, Trees trees) {
        this.compilationUnit = compilationUnit;
        this.trees = trees;
        this.sourcePositions = trees.getSourcePositions();
        this.lineMap = compilationUnit.getLineMap();
    }

    CompilationUnitTree getCompilationUnit() {
        return this.compilationUnit;
    }

    Trees getTrees() {
        return this.trees;
    }

    TreePath getNodePath(Tree node) {
        TreePath treePath = this.trees.getPath(this.compilationUnit, node);
        Preconditions.checkArgument((treePath != null ? 1 : 0) != 0, (String)"The node provided was not a subtree of the CompilationUnitTree in this TreeContext. CompilationUnit: %s; Node:", (Object[])new Object[]{this.compilationUnit, node});
        return treePath;
    }

    long getNodeStartLine(Tree node) {
        long startPosition = this.getNodeStartPosition(node);
        return startPosition == -1L ? -1L : this.lineMap.getLineNumber(startPosition);
    }

    long getNodeStartColumn(Tree node) {
        long startPosition = this.getNodeStartPosition(node);
        return startPosition == -1L ? -1L : this.lineMap.getColumnNumber(startPosition);
    }

    long getNodeEndLine(Tree node) {
        long endPosition = this.getNodeEndPosition(node);
        return endPosition == -1L ? -1L : this.lineMap.getLineNumber(endPosition);
    }

    long getNodeEndColumn(Tree node) {
        long endPosition = this.getNodeEndPosition(node);
        return endPosition == -1L ? -1L : this.lineMap.getColumnNumber(endPosition);
    }

    long getNodeStartPosition(Tree node) {
        for (TreePath currentNode = this.getNodePath(node); currentNode != null; currentNode = currentNode.getParentPath()) {
            long startPosition = this.sourcePositions.getStartPosition(this.compilationUnit, currentNode.getLeaf());
            if (startPosition == -1L) continue;
            return startPosition;
        }
        return -1L;
    }

    long getNodeEndPosition(Tree node) {
        TreePath currentNode = this.getNodePath(node);
        while (node != null) {
            long endPosition = this.sourcePositions.getEndPosition(this.compilationUnit, currentNode.getLeaf());
            if (endPosition != -1L) {
                return endPosition;
            }
            currentNode = currentNode.getParentPath();
        }
        return -1L;
    }
}

