/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core;

import com.google.code.flyway.core.MetaDataTable;
import com.google.code.flyway.core.Migration;
import com.google.code.flyway.core.MigrationResolver;
import com.google.code.flyway.core.MigrationState;
import com.google.code.flyway.core.SchemaVersion;
import com.google.code.flyway.core.dbsupport.DbSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DbMigrator {
    private static final Log LOG = LogFactory.getLog(DbMigrator.class);
    private final SchemaVersion targetVersion = SchemaVersion.LATEST;
    private final DbSupport dbSupport;
    private final Collection<MigrationResolver> migrationResolvers;
    private final MetaDataTable metaDataTable;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplate jdbcTemplate;

    public DbMigrator(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, Collection<MigrationResolver> migrationResolvers, MetaDataTable metaDataTable) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.migrationResolvers = migrationResolvers;
        this.metaDataTable = metaDataTable;
    }

    public int migrate() throws Exception {
        int result;
        if (!this.metaDataTable.exists()) {
            this.metaDataTable.create();
        }
        final List<Migration> allMigrations = this.findAvailableMigrations();
        int migrationSuccessCount = 0;
        while ((result = ((Integer)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction(TransactionStatus status) {
                DbMigrator.this.metaDataTable.lock();
                Migration latestAppliedMigration = DbMigrator.this.metaDataTable.latestAppliedMigration();
                LOG.info((Object)("Current schema version: " + latestAppliedMigration.getVersion()));
                latestAppliedMigration.assertNotFailed();
                Migration migration = DbMigrator.this.getNextMigration(allMigrations, latestAppliedMigration.getVersion());
                if (migration == null) {
                    LOG.info((Object)"Schema is up to date. No migration necessary.");
                    return 0;
                }
                LOG.info((Object)("Migrating to version " + migration.getVersion() + " - " + migration.getScriptName()));
                migration.migrate(DbMigrator.this.transactionTemplate, DbMigrator.this.jdbcTemplate, DbMigrator.this.dbSupport);
                if (MigrationState.FAILED.equals((Object)migration.getState()) && DbMigrator.this.dbSupport.supportsDdlTransactions()) {
                    throw new IllegalStateException("Migration failed! Changes rolled back. Aborting!");
                }
                DbMigrator.this.metaDataTable.migrationFinished(migration);
                migration.assertNotFailed();
                return 1;
            }
        })).intValue()) != 0) {
            migrationSuccessCount += result;
        }
        if (migrationSuccessCount == 0) {
            LOG.info((Object)"Migration completed.");
        } else if (migrationSuccessCount == 1) {
            LOG.info((Object)"Migration completed. Successfully applied 1 migration.");
        } else {
            LOG.info((Object)("Migration completed. Successfully applied " + migrationSuccessCount + " migrations."));
        }
        return migrationSuccessCount;
    }

    private Migration getNextMigration(List<Migration> allMigrations, SchemaVersion currentVersion) {
        SchemaVersion newestMigrationVersion = allMigrations.get(0).getVersion();
        if (newestMigrationVersion.compareTo(currentVersion) < 0) {
            LOG.warn((Object)("Database version (" + currentVersion.getVersion() + ") is newer than the latest migration (" + newestMigrationVersion + ") !"));
            return null;
        }
        Migration nextMigration = null;
        for (Migration migration : allMigrations) {
            if (migration.getVersion().compareTo(currentVersion) > 0 && migration.getVersion().compareTo(this.targetVersion) <= 0) {
                nextMigration = migration;
                continue;
            }
            return nextMigration;
        }
        return nextMigration;
    }

    private List<Migration> findAvailableMigrations() {
        ArrayList<Migration> allMigrations = new ArrayList<Migration>();
        for (MigrationResolver migrationResolver : this.migrationResolvers) {
            allMigrations.addAll(migrationResolver.resolvesMigrations());
        }
        if (allMigrations.isEmpty()) {
            LOG.warn((Object)"No migrations found!");
            return allMigrations;
        }
        Collections.sort(allMigrations, new Comparator<Migration>(){

            @Override
            public int compare(Migration o1, Migration o2) {
                return o2.getVersion().compareTo(o1.getVersion());
            }
        });
        return allMigrations;
    }
}

