/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core;

import com.google.code.flyway.core.DbMigrator;
import com.google.code.flyway.core.MetaDataTable;
import com.google.code.flyway.core.MigrationResolver;
import com.google.code.flyway.core.SqlScript;
import com.google.code.flyway.core.dbsupport.DbSupport;
import com.google.code.flyway.core.dbsupport.h2.H2DbSupport;
import com.google.code.flyway.core.dbsupport.hsql.HsqlDbSupport;
import com.google.code.flyway.core.dbsupport.mysql.MySQLDbSupport;
import com.google.code.flyway.core.dbsupport.oracle.OracleDbSupport;
import com.google.code.flyway.core.java.JavaMigrationResolver;
import com.google.code.flyway.core.sql.SqlMigrationResolver;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private String basePackage = "db.migration";
    private String baseDir = "db/migration";
    private String schemaMetaDataTable = "schema_version";
    private Map<String, String> placeholders;
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    private DbSupport dbSupport;
    private MetaDataTable metaDataTable;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setSchemaMetaDataTable(String schemaMetaDataTable) {
        this.schemaMetaDataTable = schemaMetaDataTable;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public MetaDataTable getMetaDataTable() {
        return this.metaDataTable;
    }

    public void setDataSource(DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.dbSupport = this.initDbSupport();
        LOG.debug((Object)("Schema: " + this.dbSupport.getCurrentSchema(this.jdbcTemplate)));
        this.metaDataTable = new MetaDataTable(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.schemaMetaDataTable);
    }

    public int migrate() throws Exception {
        if (!this.dbSupport.supportsLocking()) {
            LOG.info((Object)(this.getDatabaseProductName() + " does not support locking. No concurrent migration supported."));
        }
        ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
        migrationResolvers.add(new SqlMigrationResolver(this.baseDir, this.placeholders));
        migrationResolvers.add(new JavaMigrationResolver(this.basePackage));
        DbMigrator dbMigrator = new DbMigrator(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, migrationResolvers, this.metaDataTable);
        return dbMigrator.migrate();
    }

    public void clean() {
        LOG.debug((Object)"Starting to drop all database objects ...");
        SqlScript dropAllObjectsScript = this.dbSupport.createCleanScript(this.jdbcTemplate);
        dropAllObjectsScript.execute(this.transactionTemplate, this.jdbcTemplate);
        LOG.info((Object)("Cleaned database schema " + this.dbSupport.getCurrentSchema(this.jdbcTemplate)));
    }

    private DbSupport initDbSupport() {
        String databaseProductName = this.getDatabaseProductName();
        LOG.debug((Object)("Database: " + databaseProductName));
        ArrayList<DbSupport> dbSupports = new ArrayList<DbSupport>();
        dbSupports.add(new HsqlDbSupport());
        dbSupports.add(new H2DbSupport());
        dbSupports.add(new MySQLDbSupport());
        dbSupports.add(new OracleDbSupport());
        for (DbSupport dbSupport : dbSupports) {
            if (!dbSupport.supportsDatabase(databaseProductName)) continue;
            return dbSupport;
        }
        throw new IllegalArgumentException("Unsupported Database: " + databaseProductName);
    }

    private String getDatabaseProductName() {
        return (String)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData == null) {
                    throw new IllegalStateException("Unable to read database metadata while it is null!");
                }
                return connection.getMetaData().getDatabaseProductName();
            }
        });
    }
}

