/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core;

import com.google.code.flyway.core.Migration;
import com.google.code.flyway.core.MigrationState;
import com.google.code.flyway.core.SchemaVersion;
import com.google.code.flyway.core.dbsupport.DbSupport;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class MetaDataTable {
    private static final Log LOG = LogFactory.getLog(MetaDataTable.class);
    private final DbSupport dbSupport;
    private final String tableName;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;

    public MetaDataTable(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, String tableName) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.tableName = tableName;
    }

    public boolean exists() throws SQLException {
        return this.dbSupport.metaDataTableExists(this.jdbcTemplate, this.tableName);
    }

    public void create() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                String[] statements;
                for (String statement : statements = MetaDataTable.this.dbSupport.createSchemaMetaDataTableSql(MetaDataTable.this.tableName)) {
                    MetaDataTable.this.jdbcTemplate.update(statement);
                }
                return null;
            }
        });
        LOG.info((Object)("Metadata table created: " + this.tableName));
    }

    public void init() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                MetaDataTable.this.jdbcTemplate.update("INSERT INTO " + MetaDataTable.this.tableName + " (version, script, execution_time, state, current_version)" + " VALUES (0, '<< Flyway Init >>', 0, 'SUCCESS', 1)");
                return null;
            }
        });
    }

    public void lock() {
        if (this.dbSupport.supportsLocking()) {
            this.jdbcTemplate.queryForList("SELECT script FROM " + this.tableName + " FOR UPDATE");
        }
    }

    public void migrationFinished(Migration migration) {
        this.jdbcTemplate.update("UPDATE " + this.tableName + " SET current_version=0");
        this.jdbcTemplate.update("INSERT INTO " + this.tableName + " (version, description, script, execution_time, state, current_version)" + " VALUES (?, ?, ?, ?, ?, 1)", new Object[]{migration.getVersion().getVersion(), migration.getVersion().getDescription(), migration.getScriptName(), migration.getExecutionTime(), migration.getState().name()});
    }

    public Migration latestAppliedMigration() {
        final List result = this.jdbcTemplate.queryForList("select VERSION, DESCRIPTION, SCRIPT, EXECUTION_TIME, STATE from " + this.tableName + " where current_version=1");
        if (result.isEmpty()) {
            return new Migration();
        }
        return new Migration(){
            {
                this.schemaVersion = new SchemaVersion((String)((Map)result.get(0)).get("VERSION"), (String)((Map)result.get(0)).get("DESCRIPTION"));
                this.migrationState = MigrationState.valueOf((String)((Map)result.get(0)).get("STATE"));
                this.executionTime = ((Number)((Map)result.get(0)).get("EXECUTION_TIME")).intValue();
                this.scriptName = (String)((Map)result.get(0)).get("SCRIPT");
            }
        };
    }

    public int migrationCount() {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.tableName);
    }
}

