/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core;

import com.google.code.flyway.core.MigrationState;
import com.google.code.flyway.core.SchemaVersion;
import com.google.code.flyway.core.dbsupport.DbSupport;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class Migration {
    protected SchemaVersion schemaVersion = SchemaVersion.EMPTY;
    protected MigrationState migrationState = MigrationState.UNKNOWN;
    protected int executionTime = -1;
    protected String scriptName;

    public SchemaVersion getVersion() {
        return this.schemaVersion;
    }

    public MigrationState getState() {
        return this.migrationState;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void assertNotFailed() {
        if (MigrationState.FAILED == this.migrationState) {
            throw new IllegalStateException("Migration to version " + this.schemaVersion + " failed! Please restore backups and roll back database and code!");
        }
    }

    public final void migrate(final TransactionTemplate transactionTemplate, final JdbcTemplate jdbcTemplate, final DbSupport dbSupport) {
        long start = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Migration.this.doMigrate(transactionTemplate, jdbcTemplate, dbSupport);
                    Migration.this.migrationState = MigrationState.SUCCESS;
                }
                catch (Exception e) {
                    Migration.this.migrationState = MigrationState.FAILED;
                }
            }
        };
        Thread migrationThread = new Thread(runnable, "Flyway Migration");
        migrationThread.start();
        try {
            migrationThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long finish = System.currentTimeMillis();
        this.executionTime = (int)(finish - start);
    }

    protected void doMigrate(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport) throws DataAccessException {
    }
}

