/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core.dbsupport.h2;

import com.google.code.flyway.core.SqlScript;
import com.google.code.flyway.core.SqlStatement;
import com.google.code.flyway.core.dbsupport.DbSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class H2DbSupport
implements DbSupport {
    @Override
    public String[] createSchemaMetaDataTableSql(String tableName) {
        String createTableSql = "CREATE TABLE " + tableName + " (" + "    version VARCHAR(20) PRIMARY KEY," + "    description VARCHAR(100)," + "    script VARCHAR(100) NOT NULL," + "    installed_on TIMESTAMP DEFAULT CURRENT_TIMESTAMP," + "    execution_time INT," + "    state VARCHAR(15) NOT NULL," + "    current_version BOOLEAN NOT NULL," + "    CONSTRAINT unique_script UNIQUE (script)" + ")";
        String addIndexSql = "CREATE INDEX " + tableName + "_current_version_index ON " + tableName + " (current_version)";
        return new String[]{createTableSql, addIndexSql};
    }

    @Override
    public String getCurrentSchema(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getSchemas();
                while (resultSet.next()) {
                    if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                    return resultSet.getString("TABLE_SCHEM");
                }
                return null;
            }
        });
    }

    @Override
    public boolean supportsDatabase(String databaseProductName) {
        return "H2".equals(databaseProductName);
    }

    @Override
    public boolean metaDataTableExists(final JdbcTemplate jdbcTemplate, final String schemaMetaDataTable) {
        return (Boolean)jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, H2DbSupport.this.getCurrentSchema(jdbcTemplate), schemaMetaDataTable.toUpperCase(), null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsLocking() {
        return true;
    }

    @Override
    public SqlScript createSqlScript(Resource resource, Map<String, String> placeholders) {
        return new SqlScript(resource, placeholders);
    }

    @Override
    public SqlScript createCleanScript(JdbcTemplate jdbcTemplate) {
        return new SqlScript(new ArrayList<SqlStatement>(), "Clean schema " + this.getCurrentSchema(jdbcTemplate));
    }
}

