/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core.dbsupport.mysql;

import com.google.code.flyway.core.SqlScript;
import com.google.code.flyway.core.SqlStatement;
import com.google.code.flyway.core.dbsupport.DbSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class MySQLDbSupport
implements DbSupport {
    @Override
    public String[] createSchemaMetaDataTableSql(String tableName) {
        String createTableSql = "CREATE TABLE " + tableName + " (" + "    version VARCHAR(20) NOT NULL UNIQUE," + "    description VARCHAR(100)," + "    script VARCHAR(100) NOT NULL UNIQUE," + "    installed_on TIMESTAMP DEFAULT CURRENT_TIMESTAMP," + "    execution_time INT," + "    state VARCHAR(15) NOT NULL," + "    current_version BOOL NOT NULL," + "    PRIMARY KEY(version)" + ") ENGINE=InnoDB";
        String addIndexSql = "ALTER TABLE " + tableName + " ADD INDEX " + tableName + "_current_version_index (current_version)";
        return new String[]{createTableSql, addIndexSql};
    }

    @Override
    public String getCurrentSchema(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getCatalog();
            }
        });
    }

    @Override
    public boolean supportsDatabase(String databaseProductName) {
        return "MySQL".equals(databaseProductName);
    }

    @Override
    public boolean metaDataTableExists(final JdbcTemplate jdbcTemplate, final String schemaMetaDataTable) {
        return (Boolean)jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(MySQLDbSupport.this.getCurrentSchema(jdbcTemplate), null, schemaMetaDataTable, null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsLocking() {
        return true;
    }

    @Override
    public SqlScript createSqlScript(Resource resource, Map<String, String> placeholders) {
        return new SqlScript(resource, placeholders);
    }

    @Override
    public SqlScript createCleanScript(JdbcTemplate jdbcTemplate) {
        List tableNames = jdbcTemplate.queryForList("SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'", String.class, new Object[]{this.getCurrentSchema(jdbcTemplate)});
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String tableName : tableNames) {
            sqlStatements.add(new SqlStatement(lineNumber, "DROP TABLE " + tableName));
        }
        return new SqlScript(sqlStatements, "Clean schema " + this.getCurrentSchema(jdbcTemplate));
    }
}

